#ifndef HV_H_SEEN
#define HV_H_SEEN

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#include <termios.h>	    // POSIX terminal control definitions
#include <fcntl.h>  	    // File control definitions
#include <unistd.h>
#include <sys/ioctl.h>

#define MAX_COM_SIZE 1000   // Maximum text buffer size
#define RBUF_LEN 10  	    // Maximum read buffer length
#define BAUDRATE B115200    // Baudrate for serial communication

#define MAX_NUM_BOARDS 13	// Maximum number of boards per crate
#define NUM_CHANNELS 32		// Channels per bias board

class HVBoard {
    
  public:
   HVBoard(int, char *);
   ~HVBoard();

	struct {
	  int BoardNumber;
	  bool WrapOK;
	  int WrapCounter;
	  bool Acknowledge;
	  int Current;
	  bool Overcurrent;
	  bool Reset;
	} Status;

   int fDescriptor; 
   int LastWrapCount;
   double fTimeOut;      // [s] timeout to return from read 
  
   char *BoardName; 
   int BoardNumber;

   int SystemReset();
   int ReadChannel(int, int);
   int GlobalSet(int);
   int ChannelSet(int, int, int);
   bool SynchBoard();
   int Communicate(unsigned char*, int);
};

#endif
