#ifndef MARS_MHEffOnTime
#define MARS_MHEffOnTime

#ifndef MARS_MH
#include "MH.h"
#endif
#ifndef ROOT_TH1
#include "TH1.h"
#endif

class TH2D;
class MHTimeDiffTheta;
class MParList;

class MHEffOnTime : public MH
{
private:
    TH1D fHEffOn;
    TH1D fHProb;
    TH1D fHLambda;
    TH1D fHRdead;

    TString fVarname;
    TString fUnit;

    void ResetBin(Int_t i);
    Bool_t CalcResults(const TF1 &func, Double_t Nm, Int_t i);
    void DrawBin(TH1 &h, Int_t i) const;
    void GetQuantiles(const TH1 &h, Double_t min, Double_t max, Double_t yq[2]) const;

public:
    MHEffOnTime(const char *varname=NULL, const char *unit=NULL);

    Bool_t SetupFill(const MParList *pList);

    const TH1D *GetHist() { return &fHEffOn; }
    const TH1D *GetHist() const { return &fHEffOn; }

    void Calc(const TH2D *hist, const Bool_t Draw);
    void Calc(const MHTimeDiffTheta &hist, const Bool_t Draw);

    void Draw(Option_t *option="");

    ClassDef(MHEffOnTime, 0) //1D-plot of Delta t vs. Var
};

#endif

