#ifndef MARS_MHillasCalc
#define MARS_MHillasCalc

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MHillasCalkc                                                            //
//                                                                         //
// Task to calculate Hillas Parameters                                     //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MGeomCam;
class MCerPhotEvt;
class MHillas;
class MHillasExt;
class MNewImagePar;

class MHillasCalc : public MTask
{
    const MGeomCam    *fGeomCam;    // Camera Geometry used to calculate Hillas
    const MCerPhotEvt *fCerPhotEvt; // Cerenkov Photon Event used for calculation

    MHillas      *fHillas;     // output container to store result
    MHillasExt   *fHillasExt;
    MNewImagePar *fNewImgPar;

    TString      fHilName;
    TString      fHilExtName;
    TString      fImgParName;

    Int_t        fErrors[5];

    Int_t        fFlags;

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t PostProcess();

    enum CalcCont_t {
        kCalcHillas      = BIT(0),
        kCalcHillasExt   = BIT(1),
        //kCalcHillasSrc   = BIT(2),
        kCalcNewImagePar = BIT(3)
    };

public:
    MHillasCalc(const char *name=NULL, const char *title=NULL);

    void SetNameHillas(const char *name)    { fHilName = name;    }
    void SetNameHillasExt(const char *name) { fHilExtName = name; }
    void SetNameNewImgPar(const char *name) { fImgParName = name; }

    void SetFlags(Int_t f) { fFlags  =  f; }
    void Enable(Int_t f)   { fFlags |=  f; }
    void Disable(Int_t f)  { fFlags &= ~f; }
    Bool_t TestFlag(CalcCont_t i) const { return fFlags&i; }

    ClassDef(MHillasCalc, 0)   // Task to calculate Hillas parameters
};

#endif
