----------------------------------------------------------------------------------
-- Company:        ETH Zurich, Institute for Particle Physics
-- Engineer:       P. Vogler, Q. Weitzel
-- 
-- Create Date:    04/05/2010 
-- Design Name:    
-- Module Name:    FTU_test1 - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description:    Test firmware for FTU board, switch on/off enable signals										
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity FTU_test1 is
  port(
    -- global control 
    ext_clk   : IN  STD_LOGIC;                      -- external clock from FTU board
    --reset     : in  STD_LOGIC;                      -- reset
    brd_add   : IN  STD_LOGIC_VECTOR(5 downto 0);   -- global board address (not local)

    -- rate counters LVDS inputs
    -- use IBUFDS differential input buffer
    patch_A_p     : IN  STD_LOGIC;                  -- logic signal from first trigger patch
    patch_A_n     : IN  STD_LOGIC;           
    patch_B_p     : IN  STD_LOGIC;                  -- logic signal from second trigger patch
    patch_B_n     : IN  STD_LOGIC;
    patch_C_p     : IN  STD_LOGIC;                  -- logic signal from third trigger patch
    patch_C_n     : IN  STD_LOGIC;
    patch_D_p     : IN  STD_LOGIC;                  -- logic signal from fourth trigger patch
    patch_D_n     : IN  STD_LOGIC;
    trig_prim_p   : IN  STD_LOGIC;                  -- logic signal from n-out-of-4 circuit
    trig_prim_n   : IN  STD_LOGIC;
    
    -- DAC interface
    -- miso          : IN  STD_LOGIC;                  -- master-in-slave-out
    sck           : OUT STD_LOGIC;                  -- serial clock to DAC
    mosi          : OUT STD_LOGIC;                  -- serial data to DAC, master-out-slave-in
    clr           : OUT STD_LOGIC;                  -- clear signal to DAC
    cs_ld         : OUT STD_LOGIC;                  -- chip select or load to DAC
    
    -- RS-485 interface to FTM
    rx            : IN  STD_LOGIC;                  -- serial data from FTM
    tx            : OUT STD_LOGIC;                  -- serial data to FTM
    rx_en         : OUT STD_LOGIC;                  -- enable RS-485 receiver
    tx_en         : OUT STD_LOGIC;                  -- enable RS-485 transmitter

    -- analog buffer enable
    enables_A   : OUT STD_LOGIC_VECTOR(8 downto 0);  -- individual enables for analog inputs
    enables_B   : OUT STD_LOGIC_VECTOR(8 downto 0);  -- individual enables for analog inputs
    enables_C   : OUT STD_LOGIC_VECTOR(8 downto 0);  -- individual enables for analog inputs
    enables_D   : OUT STD_LOGIC_VECTOR(8 downto 0);  -- individual enables for analog inputs

    -- testpoints
    TP_A       : out STD_LOGIC_VECTOR(11 downto 0)   -- testpoints    
  );
end FTU_test1;

architecture Behavioral of FTU_test1 is

  component FTU_test1_dcm
    port(
      CLKIN_IN        : IN  STD_LOGIC;
      CLKFX_OUT       : OUT STD_LOGIC;
      CLKIN_IBUFG_OUT : OUT STD_LOGIC
    );
  end component;

  component Clock_Divider
    port(
      clock      : IN  STD_LOGIC;
      enable_out : OUT STD_LOGIC
    );
  end component;
  
  signal clk_5M_sig : STD_LOGIC;
  signal enable_sig : STD_LOGIC;
  
begin

  Inst_FTU_test1_dcm : FTU_test1_dcm
    port map(
      CLKIN_IN => ext_clk,
      CLKFX_OUT => clk_5M_sig,
      CLKIN_IBUFG_OUT => open
    );

  Inst_Clock_Divider : Clock_Divider
    port map (
      clock => clk_5M_sig,
      enable_out => enable_sig
    );

  enables_A(8) <= enable_sig;
  enables_B(8) <= enable_sig;
  enables_C(8) <= enable_sig;
  enables_D(8) <= enable_sig;

end Behavioral;


library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity Clock_Divider is
  port(
    clock     : in  std_logic;
    enable_out: out std_logic
    );
end entity Clock_Divider;

architecture RTL of Clock_Divider is
  
  constant max_count   : integer := 5000000/1000000; -- for simulation
  --constant max_count   : integer := 5000000/1;   -- for implementation
  constant final_count : integer := 3;
  
begin

  process(clock)
    variable count  : integer range 0 to max_count;
    variable count2 : integer range 0 to final_count;
  begin
    if rising_edge(clock) then
      --enable_out <= '0';      
      if count2 = final_count then
        enable_out <= '0';
      else
        if count < max_count/2 then          
          enable_out <= '0';
          count := count + 1;
        elsif count < max_count then
          enable_out <= '1';
          count := count + 1;
        else
          count := 0;
          enable_out <= '0';
          count2 := count2 + 1;
        end if; 
      end if;
    end if;
  end process;

end architecture RTL;
