
#ifndef PROCESSIO_H_SEEN
#define PROCESSIO_H_SEEN

#include <stdarg.h>
#include <errno.h>
#include <math.h>
#include <signal.h>

#define SERVER_NAME "Bias"       // Name to use in DIM
#include "Evidence.h"

#include "HVCalib.h"
#include "HV.h"
#include "../pixelmap/PixelMap.h"

#define MAX_COM_SIZE 5000
#define NUM_CHAINS 4
#define NUM_CHANNELS 32
#define BUFFER_LENGTH 256

#define MIN_TIMEOUT 0.01
#define MAX_TIMEOUT 5.0

#define MIN_RATE 0.01
#define MAX_RATE 50.0

#define MAX_NUM_TOKEN 10

enum MsgTarget {Console=1, Log=2, All=7};
typedef enum stateenum {active, stopped, na} state_enum;

class ProcessIO: public DimCommand, public EvidenceServer {

  time_t StartTime;
  PixelMap *pm;
  float UpdateDelay;

  void commandHandler();

 public:

  HVCalib     *calib;
  HVBoard **fHVBoard;
  
  pthread_mutex_t control_mutex;

  char Prompt[MAX_COM_SIZE];
  const char *Param[MAX_NUM_TOKEN]; // For parser
  int NParam;

  // Configuration data
  char *fPixMapTable;
  float fTimeOut;
  float fStatusRefreshRate;
  int DACMin;
  int DACMax;
  float fHVCalibOffset;
  float fHVCalibSlope;
  unsigned int fHVMaxDiff;

  // Status variables  
  pthread_t HVMonitor;       // exit function sends signal to these threads
  
  int NumHVBoards;
  int FirstBoard;
  int LastBoard;
  int FirstChain;
  int LastChain;
  
  state_enum   state;
  bool Exit;
    
  // Methods
  ProcessIO();
  ~ProcessIO();

  void PrintMessage(MsgTarget, const char *, ...);
  void PrintMessage(const char *, ...);
  void DoPrintMessage(const char *, va_list, MsgTarget);
  void CommandControl(char*);
  bool RampVoltage(unsigned int, int, int, int);
  void Monitor();
  void ResetBoard(int);
  void PrintBoardStatus(int);
  int ParseInput(char*, const char *Param[]);
};

bool Match(const char *, const char *);
bool ConvertToDouble(const char *, double *);
bool ConvertToInt(const char *, int *);

#endif
