#ifndef DAQREADOUT_H_SEEN
#define DAQREADOUT_H_SEEN

#define SERVER_NAME "drsdaq"       // Name to use in DIM
#include "Evidence.h"

#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>
#include <time.h>
#include <errno.h>
#include <unistd.h>
#include <sys/socket.h>
#include <pthread.h>
#include <fcntl.h>
#include <dirent.h>
#include <sys/vfs.h>
#include <signal.h>
#include <sys/time.h>

#include "RawDataCTX.h"
#include "DRS.h"
#include "HVFeedback.h"

#define MAX_PATH 256		// also used for filename length
#define MAX_COM_SIZE 10000
#define MAX_NUM_TOKEN 10

#define MsgToConsole 1
#define MsgToLog 2

enum state_enum {active, stopped};
enum runtype_enum {data, pedestal, reserved, test};

class DAQReadout : public DRS, public DRSCallback, public DimCommand, public EvidenceServer {

    time_t StartTime;
	pid_t MainThread;
	DimService *EventService;
	int MinDelay;
    unsigned int CmdNumber;

    void PrintUsage();
	void commandHandler();

    pthread_mutex_t Mutex;
    int Rawfile;
    class HVFeedback* HVFB;

    // Configuration data
    char *fCalibDataPath;
    char *fRawDataPath;
    int fMinDiskSpaceMB;   // Minimum required disk space in MBytes
    int fMaxFileSizeMB;    // Maximum File size in Bytes 
    int fFirstSample;
    unsigned int fSamples;
    double fDefaultFrequency;

    state_enum   daq_state;
    runtype_enum daq_runtype;
    bool Stop;	      	      	// Set to true to stop run
    unsigned int NumEvents;		// Number of event taken            
    unsigned int NumEventsRequested;	// Number of events requested
    int RunNumber; 
    unsigned int FileNumber; 
    char FileName[MAX_PATH];
    char CalibInfoFilename[MAX_PATH];
	
  public:
    RunHeader*   RHeader;
    EventHeader* EHeader;
    BoardStructure *BStruct;
    
    short (*WaveForm)[kNumberOfChipsMax][kNumberOfChannelsMax][kNumberOfBins];
    int (*TriggerCell)[kNumberOfChipsMax];
	char *DIMEventData;
    
    char Prompt[MAX_COM_SIZE];

    int NParam;       	      	// Number of command parameters
    const char *Param[MAX_NUM_TOKEN]; // Pointers to parameters
    int NumBoards;
    int FirstBoard;
    int LastBoard;
    float *DRSFreq;   	      	// DRS sampling frequency [GHz]
    bool *ACalib;
    double *ACalibTemp;
    bool *TCalib;

    DAQReadout();
    ~DAQReadout();

    void cmd_exit();	   void cmd_help();
    void cmd_board();	   void cmd_status();
    void cmd_led(); 	   void cmd_freq();
    void cmd_acalib();	   void cmd_serial();
    void cmd_trigger();	   void cmd_centre();
	void cmd_refclk();
    void cmd_wmode();	   void cmd_rmode();
    void cmd_dmode();	   void cmd_read();
    void cmd_stop();	   void cmd_chiptest();
    void cmd_eepromtest(); void cmd_tcalib();
    void cmd_regtest();	   void cmd_ramtest();
	void cmd_take();	   void cmd_update();
    void cmd_config();	   void cmd_events();
    void cmd_disk();	   void cmd_uptime();
      
    void cmd_fmode(); 	   void cmd_faverage();
    void cmd_ftarget();    void cmd_fgain();
    void cmd_fresponse();  void cmd_fconfig();

    void Execute(char*);  
    void StartDRS();
    void StopDRS();
    void StopRun();
    bool IsDRSBusy();
    bool IsDRSFreqSet();
    void SetDRSFrequency(double, bool);
    void SetDOMINOMode(int);
    void SetDOMINOReadMode(int);
    void SetDOMINOWaveMode(int);
    void SetDelayedStart(int);
    void HWTrigger(int); 
    bool ReadCalibration();
    void ReadCalibratedDRSData();
    void PrintConfig(int);
    void PrintMessage(int, const char*, ...);
    void PrintMessage(const char*, ...);
    void DoPrintMessage(const char*, va_list, int); 
    bool OpenRawFile();
    bool WriteRunHeader();
    bool UpdateRunHeader(unsigned int, bool);
    bool WriteEvent();
	void DAQ();
    
    void Progress(int);
};

void DAQ(DAQReadout *);
void Execute(char *);

bool Match(const char*, const char*);
int ParseInput(char*, const char *Param[]);
int CheckDisk(char*);

#endif
