#ifndef MARS_MLogManip
#define MARS_MLogManip

#include <iomanip.h>

// ----------------------------------------------------------------
//                 Definitions of the manipulators
// ----------------------------------------------------------------

//
// define a general simple macro for manipulator definitions (int)
//
#define MANIPULATOR0(name) \
   extern ostream& ##name(ostream& lout);

#ifndef OMANIP
   #define MANIPULATOR1(name) \
      extern ostream& __omanip_##name(ostream& lout, int i); \
      inline omanip<int> ##name(int i)                \
      {                                               \
         return omanip<int>(__omanip_##name, i);     \
      }

#else
   #define MANIPULATOR1(name) \
       extern ostream& __omanip_##name(ostream& lout, int i); \
       inline OMANIP(int) ##name(int i)                \
       {                                               \
          return OMANIP(int)(__omanip_##name, i);      \
       }

#endif

//
// definitions
//
MANIPULATOR0(underline); // underline output
MANIPULATOR1(debug);     // set debug level
MANIPULATOR1(device);    // set ouput devices
MANIPULATOR1(edev);      // enable additional output devices
MANIPULATOR1(ddev);      // disable given output
//#ifndef __CINT__
//__DEFINE_IOMANIP_FN1(smanip, int, debug);    // set debug level
//__DEFINE_IOMANIP_FN1(smanip, int, device);   // set ouput devices
//__DEFINE_IOMANIP_FN1(smanip, int, edev);     // enable additional output devices
//__DEFINE_IOMANIP_FN1(smanip, int, ddev);     // disable given output
//#endif

// ----------------------------------------------------------------
//                         Debug helper macros
// ----------------------------------------------------------------

//
// Output debug information into the stream
//  - this can only be done by a macro
//
#ifndef __CINT__
#define dbginf dbg << __FILE__ << " l." << dec << __LINE__ << ": "
#define all    debug(0) // use this for output in any case
#define err    debug(1) // use this for fatal errors (red)
#define warn   debug(2) // use this for wrnings (yellow)
#define inf    debug(3) // use this for informations (green)
#define dbg    debug(4) // use this for debug messages (blue)
#endif
//
// flush the old buffer, set a new debug level
// and output the debug information code
//
// Be careful: Only use them with a MLogging stream facility.
// Remark:     All this is compiled into the code.
//
/*
#ifndef __CINT__
#define DEBUG(lvl)  flush << debug(lvl) << dbginf
#endif
*/
/*
class SMANIP(T) {
    ios& (*fct)(ios&,T) ;
    T arg ;
public:
    SMANIP(T)(ios& (*f)(ios&, T), T a) :
        fct(f), arg(a) { }
        friend istream& operator>>(istream& i, const SMANIP(T)& m)
        {
            ios* s = &i ;
            (*m.fct)(*s,m.arg) ; return i ;
        }
        friend ostream& operator<<(ostream& o, const SMANIP(T)& m)
        {
            ios* s = &o ;
            (*m.fct)(*s,m.arg) ; return o ;
        }
} ;
*/

#endif
