#include "MRflEvtData.h"

#include "MLog.h"
#include "MLogManip.h"

ClassImp(MRflEvtData);

// --------------------------------------------------------------------------
//
// Creates a MCerPhotPix object for each pixel in the event
//
MRflEvtData::MRflEvtData(const char *name, const char *title)
   : fList("MRflSinglePhoton", 0), fPos(0)
{
    fName  = name  ? name  : "MRflEvtData";
    fTitle = title ? title : "All Photons from a reflector event";
}

void MRflEvtData::Print(Option_t *o="") const
{
    *fLog << all << underline << GetDescriptor() << ":" << endl;
    fList.Print();
}

MRflSinglePhoton &MRflEvtData::GetNewPhoton()
{
    // If necessary the []-operator creates a new element
    // Warning: The virtual table may not be set correctly,
    //          this is why you have to call the new-operator.
    return *new (fList[fPos++]) MRflSinglePhoton;
}

void MRflEvtData::FixSize()
{
    if (fList.GetEntriesFast() == fPos)
        return;

    fList.ExpandCreateFast(fPos);
}

