#ifndef MARS_MReadRflFile
#define MARS_MReadRflFile

#ifndef ROOT_TArrayF
#include <TArrayF.h>
#endif

#ifndef MARS_MRead
#include "MRead.h"
#endif

class TList;
class MRflEvtData;

class MReadRflFile : public MRead
{
private:
    ifstream *fIn;          // the inputfile
    TList    *fFileNames;   // Array which stores the \0-terminated filenames

    MRflEvtData *fEvt;        //!

    UInt_t fNumFile;
    UInt_t fEntries; // TO BE IMPLEMENTED

    Float_t fCurrentVersion; //! Version of currently open rfl file

    float  ReadVersion();
    Bool_t ReadEvtHeader();
    Bool_t ReadEvtData();
    int    ReadFlag();
    Bool_t FlagIsA(const  char *s1, const char *flag);
    Int_t  EvalFlag();
    Bool_t OpenNextFile();

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t PostProcess();

public:
    MReadRflFile(const char *filename=NULL,
                 const char *name=NULL,
                 const char *title=NULL);

    ~MReadRflFile();

    void AddFile(const char *fname);

    Bool_t Rewind() { fNumFile=0; return kTRUE; }
    UInt_t GetEntries() { return fEntries; }

    ClassDef(MReadRflFile, 0) // Reads reflector files
};

#endif
