#ifndef MARS_MRflEvtData
#define MARS_MRflEvtData

#ifndef MARS_MRflSinglePhoton
#include "MRflSinglePhoton.h"
#endif

#ifndef ROOT_TClonesArray
#include <TClonesArray.h>
#endif

class MRflEvtData : public MParContainer
{
    TClonesArray fList;
    Int_t fPos;

public:
    MRflEvtData(const char *name=NULL, const char *title=NULL);

    void Reset() { fPos = 0; }

    Int_t GetNumPhotons() const { return fList.GetEntriesFast(); }

    MRflSinglePhoton &GetNewPhoton();
    void FixSize();

    const MRflSinglePhoton &GetPhoton(Int_t i) const { return (MRflSinglePhoton&)*fList.UncheckedAt(i); }

    void Print(Option_t *o="") const;
    ClassDef(MRflEvtData, 0)
};

#endif
