/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz, 5/2003 <mailto:tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2003
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
// MCurrents (PRELIMINARY)
//
/////////////////////////////////////////////////////////////////////////////
#include "MCurrents.h"

#include <TMath.h>

#include "MLog.h"
#include "MLogManip.h"

ClassImp(MCurrents);

// --------------------------------------------------------------------------
//
// Default constructor.
//
MCurrents::MCurrents(Int_t size, const char *name, const char *title)
    : fArray(size)
{
    fName  = name  ? name  : "MCurrents";
    fTitle = title ? title : "Storage container for the pixel currents";
}

// --------------------------------------------------------------------------
//
// Print the hillas Parameters to *fLog
//
void MCurrents::Print(Option_t *) const
{
    *fLog << all << underline << GetDescriptor() << endl;
    for (int i=0; i<fArray.GetSize(); i++)
        *fLog << " " << GetCurrent(i);
    *fLog << endl;
}

UInt_t MCurrents::GetMin() const
{
    UInt_t val = (UInt_t)-1;
    for (int i=0; i<fArray.GetSize(); i++)
        val = TMath::Min(val, GetCurrent(i));
    return val;
}

UInt_t MCurrents::GetMax() const
{
    UInt_t val = 0;
    for (int i=0; i<fArray.GetSize(); i++)
        val = TMath::Max(val, GetCurrent(i));
    return val;
}
