-- VHDL Entity FACT_FAD_lib.spi_interface.symbol
--
-- Created:
--          by - kai.UNKNOWN (E5PCXX)
--          at - 14:16:38 19.05.2010
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.1 (Build 12)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
LIBRARY FACT_FAD_lib;
USE FACT_FAD_lib.fad_definitions.all;

ENTITY spi_interface IS
   PORT( 
      clk_50MHz      : IN     std_logic;
      config_start   : IN     std_logic;
      dac_array      : IN     dac_array_type;
      config_ready   : OUT    std_logic;
      config_started : OUT    std_logic  := '0';
      dac_cs         : OUT    std_logic;
      mosi           : OUT    std_logic  := '0';
      sclk           : OUT    std_logic;
      sensor_array   : OUT    sensor_array_type;
      sensor_cs      : OUT    std_logic_vector (3 DOWNTO 0);
      sensor_ready   : OUT    std_logic;
      sio            : INOUT  std_logic
   );

-- Declarations

END spi_interface ;

--
-- VHDL Architecture FACT_FAD_lib.spi_interface.struct
--
-- Created:
--          by - kai.UNKNOWN (E5PCXX)
--          at - 14:16:38 19.05.2010
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.1 (Build 12)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY FACT_FAD_lib;
USE FACT_FAD_lib.fad_definitions.all;

LIBRARY FACT_FAD_lib;

ARCHITECTURE struct OF spi_interface IS

   -- Architecture declarations

   -- Internal signal declarations
   SIGNAL dac_config_ready : std_logic;
   SIGNAL dac_config_start : std_logic;
   SIGNAL dac_id           : std_logic_vector(2 DOWNTO 0);
   SIGNAL data             : std_logic_vector(15 DOWNTO 0);
   SIGNAL sensor_id        : std_logic_vector(1 DOWNTO 0);
   SIGNAL sensor_start     : std_logic;
   SIGNAL sensor_valid     : std_logic;

   -- Implicit buffer signal declarations
   SIGNAL sclk_internal : std_logic;


   -- Component Declarations
   COMPONENT spi_clock_generator
   GENERIC (
      CLK_DIVIDER : integer := 25      --2 MHz @ 50 MHz
   );
   PORT (
      clk  : IN     std_logic;
      sclk : OUT    std_logic  := '0'
   );
   END COMPONENT;
   COMPONENT spi_controller
   PORT (
      clk          : IN     std_logic;
      dac_id       : IN     std_logic_vector (2 DOWNTO 0);
      dac_start    : IN     std_logic;
      sensor_id    : IN     std_logic_vector (1 DOWNTO 0);
      sensor_start : IN     std_logic;
      dac_cs       : OUT    std_logic                      := '1';
      dac_ready    : OUT    std_logic                      := '0';
      mosi         : OUT    std_logic                      := '0';
      sensor_cs    : OUT    std_logic_vector (3 DOWNTO 0)  := (others => '1');
      sensor_valid : OUT    std_logic                      := '0';
      data         : INOUT  std_logic_vector (15 DOWNTO 0) := (others => 'Z');
      sio          : INOUT  std_logic                      := 'Z'
   );
   END COMPONENT;
   COMPONENT spi_distributor
   GENERIC (
      CLK_DIVIDER : integer := 10**6
   );
   PORT (
      clk               : IN     std_logic;
      config_start      : IN     std_logic;
      dac_array         : IN     dac_array_type;
      dac_config_ready  : IN     std_logic;
      sensor_read_valid : IN     std_logic;
      config_ready      : OUT    std_logic                      := '0';
      config_started    : OUT    std_logic                      := '0';
      dac_config_start  : OUT    std_logic                      := '0';
      dac_id            : OUT    std_logic_vector (2 DOWNTO 0)  := (others => '0');
      sensor_array      : OUT    sensor_array_type;
      sensor_id         : OUT    std_logic_vector (1 DOWNTO 0)  := (others => '0');
      sensor_read_start : OUT    std_logic                      := '0';
      sensor_valid      : OUT    std_logic                      := '0';
      data              : INOUT  std_logic_vector (15 DOWNTO 0) := (others => 'Z')
   );
   END COMPONENT;

   -- Optional embedded configurations
   -- pragma synthesis_off
   FOR ALL : spi_clock_generator USE ENTITY FACT_FAD_lib.spi_clock_generator;
   FOR ALL : spi_controller USE ENTITY FACT_FAD_lib.spi_controller;
   FOR ALL : spi_distributor USE ENTITY FACT_FAD_lib.spi_distributor;
   -- pragma synthesis_on


BEGIN

   -- Instance port mappings.
   I_spi_clkgen : spi_clock_generator
      GENERIC MAP (
         CLK_DIVIDER => 25         --2 MHz @ 50 MHz
      )
      PORT MAP (
         clk  => clk_50MHz,
         sclk => sclk_internal
      );
   I_spi_controller : spi_controller
      PORT MAP (
         clk          => sclk_internal,
         sio          => sio,
         mosi         => mosi,
         dac_id       => dac_id,
         sensor_id    => sensor_id,
         data         => data,
         dac_cs       => dac_cs,
         sensor_cs    => sensor_cs,
         dac_start    => dac_config_start,
         dac_ready    => dac_config_ready,
         sensor_start => sensor_start,
         sensor_valid => sensor_valid
      );
   I_spi_distributor : spi_distributor
      GENERIC MAP (
         CLK_DIVIDER => 4*10**3
      )
      PORT MAP (
         clk               => sclk_internal,
         config_start      => config_start,
         config_ready      => config_ready,
         config_started    => config_started,
         sensor_valid      => sensor_ready,
         dac_array         => dac_array,
         sensor_array      => sensor_array,
         dac_config_start  => dac_config_start,
         dac_config_ready  => dac_config_ready,
         sensor_read_start => sensor_start,
         sensor_read_valid => sensor_valid,
         dac_id            => dac_id,
         sensor_id         => sensor_id,
         data              => data
      );

   -- Implicit buffered output assignments
   sclk <= sclk_internal;

END struct;
