-- VHDL Entity FACT_FAD_TB_lib.FAD_main_TB.symbol
--
-- Created:
--          by - kai.UNKNOWN (E5PCXX)
--          at - 16:53:17 07.05.2010
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.1 (Build 12)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.NUMERIC_STD.all;

ENTITY FAD_main_TB IS
-- Declarations

END FAD_main_TB ;

--
-- VHDL Architecture FACT_FAD_TB_lib.FAD_main_TB.struct
--
-- Created:
--          by - kai.UNKNOWN (E5PCXX)
--          at - 16:53:17 07.05.2010
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.1 (Build 12)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.NUMERIC_STD.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;
library FACT_FAD_lib;
use FACT_FAD_lib.fad_definitions.all;
USE ieee.std_logic_textio.all;
LIBRARY std;
USE std.textio.all;
LIBRARY FACT_FAD_test_devices_lib;
USE FACT_FAD_test_devices_lib.drs4_pack.all;

LIBRARY FACT_FAD_lib;
LIBRARY FACT_FAD_TB_lib;

ARCHITECTURE struct OF FAD_main_TB IS

   -- Architecture declarations

   -- Internal signal declarations
   SIGNAL RSRLOAD    : std_logic                    := '0';
   SIGNAL SRCLK      : std_logic                    := '0';
   SIGNAL addr       : std_logic_vector(9 DOWNTO 0);
   SIGNAL clk        : std_logic;
   SIGNAL cs         : std_logic                    := '1';
   SIGNAL data       : std_logic_vector(15 DOWNTO 0);
   SIGNAL int        : std_logic;
   SIGNAL led        : std_logic_vector(7 DOWNTO 0) := (OTHERS => '0');
   SIGNAL rd         : std_logic                    := '1';
   SIGNAL rst        : STD_LOGIC;
   SIGNAL trigger_in : STD_LOGIC;
   SIGNAL wiz_reset  : std_logic                    := '1';
   SIGNAL wr         : std_logic                    := '1';


   -- Component Declarations
   COMPONENT FAD_Testboard
   PORT (
      clk       : IN     STD_LOGIC ;
      trigger   : IN     STD_LOGIC ;
      wiz_int   : IN     std_logic ;
      RSRLOAD   : OUT    std_logic                     := '0';
      SRCLK     : OUT    std_logic                     := '0';
      led       : OUT    std_logic_vector (7 DOWNTO 0) := (OTHERS => '0');
      wiz_addr  : OUT    std_logic_vector (9 DOWNTO 0);
      wiz_cs    : OUT    std_logic                     := '1';
      wiz_rd    : OUT    std_logic                     := '1';
      wiz_reset : OUT    std_logic                     := '1';
      wiz_wr    : OUT    std_logic                     := '1';
      wiz_data  : INOUT  std_logic_vector (15 DOWNTO 0)
   );
   END COMPONENT;
   COMPONENT clock_generator
   GENERIC (
      clock_period : time := 20 ns;
      reset_time   : time := 50 ns
   );
   PORT (
      clk : OUT    STD_LOGIC  := '0';
      rst : OUT    STD_LOGIC  := '0'
   );
   END COMPONENT;
   COMPONENT simple_trigger
   GENERIC (
      TRIGGER_TIME : TIME := 16 us;
      PULSE_WIDTH  : TIME := 1 us
   );
   PORT (
      trigger : OUT    std_logic 
   );
   END COMPONENT;
   COMPONENT w5300_emulator
   PORT (
      addr : IN     std_logic_vector (9 DOWNTO 0);
      data : INOUT  std_logic_vector (15 DOWNTO 0);
      rd   : IN     std_logic ;
      wr   : IN     std_logic 
   );
   END COMPONENT;

   -- Optional embedded configurations
   -- pragma synthesis_off
   FOR ALL : FAD_Testboard USE ENTITY FACT_FAD_lib.FAD_Testboard;
   FOR ALL : clock_generator USE ENTITY FACT_FAD_TB_lib.clock_generator;
   FOR ALL : simple_trigger USE ENTITY FACT_FAD_TB_lib.simple_trigger;
   FOR ALL : w5300_emulator USE ENTITY FACT_FAD_TB_lib.w5300_emulator;
   -- pragma synthesis_on


BEGIN

   -- Instance port mappings.
   I_testboard : FAD_Testboard
      PORT MAP (
         clk       => clk,
         trigger   => trigger_in,
         wiz_int   => int,
         RSRLOAD   => RSRLOAD,
         SRCLK     => SRCLK,
         led       => led,
         wiz_addr  => addr,
         wiz_cs    => cs,
         wiz_rd    => rd,
         wiz_reset => wiz_reset,
         wiz_wr    => wr,
         wiz_data  => data
      );
   I_clock_generator : clock_generator
      GENERIC MAP (
         clock_period => 20 ns,
         reset_time   => 50 ns
      )
      PORT MAP (
         clk => clk,
         rst => rst
      );
   I_trigger : simple_trigger
      GENERIC MAP (
         TRIGGER_TIME => 16 us,
         PULSE_WIDTH  => 1 us
      )
      PORT MAP (
         trigger => trigger_in
      );
   I_w5300 : w5300_emulator
      PORT MAP (
         addr => addr,
         data => data,
         rd   => rd,
         wr   => wr
      );

END struct;
