-- VHDL Entity FACT_FAD_lib.FAD_Testboard.symbol
--
-- Created:
--          by - kai.UNKNOWN (E5PCXX)
--          at - 11:34:39 18.05.2010
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.1 (Build 12)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

ENTITY FAD_Testboard IS
   PORT( 
      clk       : IN     STD_LOGIC;
      trigger   : IN     STD_LOGIC;
      wiz_int   : IN     std_logic;
      CLK_25_PS : OUT    std_logic;
      CLK_50    : OUT    std_logic;
      RSRLOAD   : OUT    std_logic                     := '0';
      SRCLK     : OUT    std_logic                     := '0';
      led       : OUT    std_logic_vector (7 DOWNTO 0) := (OTHERS => '0');
      wiz_addr  : OUT    std_logic_vector (9 DOWNTO 0);
      wiz_cs    : OUT    std_logic                     := '1';
      wiz_rd    : OUT    std_logic                     := '1';
      wiz_reset : OUT    std_logic                     := '1';
      wiz_wr    : OUT    std_logic                     := '1';
      wiz_data  : INOUT  std_logic_vector (15 DOWNTO 0)
   );

-- Declarations

END FAD_Testboard ;

--
-- VHDL Architecture FACT_FAD_lib.FAD_Testboard.struct
--
-- Created:
--          by - kai.UNKNOWN (E5PCXX)
--          at - 11:34:39 18.05.2010
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.1 (Build 12)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE IEEE.NUMERIC_STD.all;

LIBRARY FACT_FAD_lib;
USE FACT_FAD_lib.fad_definitions.all;
LIBRARY FACT_FAD_test_devices_lib;
USE FACT_FAD_test_devices_lib.drs4_pack.all;
USE ieee.std_logic_unsigned.all;

LIBRARY FACT_FAD_lib;
LIBRARY FACT_FAD_test_devices_lib;

ARCHITECTURE struct OF FAD_Testboard IS

   -- Architecture declarations

   -- Internal signal declarations
   SIGNAL SROUT_in_0     : std_logic;
   SIGNAL SROUT_in_1     : std_logic;
   SIGNAL SROUT_in_2     : std_logic;
   SIGNAL SROUT_in_3     : std_logic;
   SIGNAL adc_data       : STD_LOGIC_VECTOR(11 DOWNTO 0);
   SIGNAL adc_data_array : adc_data_array_type;
   SIGNAL adc_oeb        : STD_LOGIC;
   SIGNAL adc_otr        : STD_LOGIC;
   SIGNAL adc_otr_array  : std_logic_vector(3 DOWNTO 0);
   SIGNAL board_id       : std_logic_vector(3 DOWNTO 0);
   SIGNAL crate_id       : std_logic_vector(1 DOWNTO 0);
   SIGNAL dac_cs         : std_logic;
   SIGNAL drs_channel_id : std_logic_vector(3 DOWNTO 0) := (others => '0');
   SIGNAL drs_dwrite     : std_logic                    := '1';
   SIGNAL rst            : STD_LOGIC;
   SIGNAL sclk           : std_logic;
   SIGNAL sensor_cs      : std_logic_vector(3 DOWNTO 0);
   SIGNAL sio            : std_logic;
   SIGNAL trigger_int    : STD_LOGIC                    := '0';

   -- Implicit buffer signal declarations
   SIGNAL CLK_25_PS_internal : std_logic;


   -- Component Declarations
   COMPONENT FAD_main
   PORT (
      CLK            : IN     std_logic ;
      SROUT_in_0     : IN     std_logic ;
      SROUT_in_1     : IN     std_logic ;
      SROUT_in_2     : IN     std_logic ;
      SROUT_in_3     : IN     std_logic ;
      adc_data_array : IN     adc_data_array_type ;
      adc_otr_array  : IN     std_logic_vector (3 DOWNTO 0);
      board_id       : IN     std_logic_vector (3 DOWNTO 0);
      crate_id       : IN     std_logic_vector (1 DOWNTO 0);
      trigger        : IN     std_logic ;
      wiz_int        : IN     std_logic ;
      CLK_25_PS      : OUT    std_logic ;
      CLK_50         : OUT    std_logic ;
      RSRLOAD        : OUT    std_logic                     := '0';
      SRCLK          : OUT    std_logic                     := '0';
      adc_oeb        : OUT    std_logic                     := '1';
      dac_cs         : OUT    std_logic ;
      drs_channel_id : OUT    std_logic_vector (3 DOWNTO 0) := (others => '0');
      drs_dwrite     : OUT    std_logic                     := '1';
      led            : OUT    std_logic_vector (7 DOWNTO 0) := (OTHERS => '0');
      sclk           : OUT    std_logic ;
      sensor_cs      : OUT    std_logic_vector (3 DOWNTO 0);
      wiz_addr       : OUT    std_logic_vector (9 DOWNTO 0);
      wiz_cs         : OUT    std_logic                     := '1';
      wiz_rd         : OUT    std_logic                     := '1';
      wiz_reset      : OUT    std_logic                     := '1';
      wiz_wr         : OUT    std_logic                     := '1';
      sio            : INOUT  std_logic ;
      wiz_data       : INOUT  std_logic_vector (15 DOWNTO 0)
   );
   END COMPONENT;
   COMPONENT FAD_adc_emulator
   PORT (
      adc_oeb  : IN     STD_LOGIC ;
      clk      : IN     STD_LOGIC ;
      rst      : IN     STD_LOGIC ;
      adc_data : OUT    STD_LOGIC_VECTOR (11 DOWNTO 0);
      adc_otr  : OUT    STD_LOGIC 
   );
   END COMPONENT;
   COMPONENT debouncer
   GENERIC (
      WIDTH : INTEGER := 17
   );
   PORT (
      clk         : IN     STD_LOGIC ;
      --           rst : in  STD_LOGIC;
      trigger_in  : IN     STD_LOGIC ;
      trigger_out : OUT    STD_LOGIC  := '0'
   );
   END COMPONENT;
   COMPONENT max6662_emulator
   GENERIC (
      DRS_TEMPERATURE : integer := 51
   );
   PORT (
      sclk      : IN     std_logic;
      sensor_cs : IN     std_logic_vector (3 DOWNTO 0);
      sio       : INOUT  std_logic
   );
   END COMPONENT;

   -- Optional embedded configurations
   -- pragma synthesis_off
   FOR ALL : FAD_adc_emulator USE ENTITY FACT_FAD_test_devices_lib.FAD_adc_emulator;
   FOR ALL : FAD_main USE ENTITY FACT_FAD_lib.FAD_main;
   FOR ALL : debouncer USE ENTITY FACT_FAD_test_devices_lib.debouncer;
   FOR ALL : max6662_emulator USE ENTITY FACT_FAD_test_devices_lib.max6662_emulator;
   -- pragma synthesis_on


BEGIN
   -- Architecture concurrent statements
   -- HDL Embedded Text Block 1 eb_ID
   -- hard-wired IDs
   board_id <= "0101";
   crate_id <= "01";

   -- HDL Embedded Text Block 2 eb1
   -- eb1 2           
   adc_data_array (0) <= adc_data;
   adc_data_array (1) <= adc_data;
   adc_data_array (2) <= adc_data;
   adc_data_array (3) <= adc_data;
   adc_otr_array(0) <= adc_otr;
   adc_otr_array(1) <= adc_otr;
   adc_otr_array(2) <= adc_otr;
   adc_otr_array(3) <= adc_otr;                            

   -- HDL Embedded Text Block 3 eb2
   -- eb2 3  
   SROUT_in_0 <= '1';
   SROUT_in_1 <= '0';
   SROUT_in_2 <= '1';
   SROUT_in_3 <= '0';
                                         


   -- Instance port mappings.
   I_testboard_main : FAD_main
      PORT MAP (
         CLK            => clk,
         SROUT_in_0     => SROUT_in_0,
         SROUT_in_1     => SROUT_in_1,
         SROUT_in_2     => SROUT_in_2,
         SROUT_in_3     => SROUT_in_3,
         adc_data_array => adc_data_array,
         adc_otr_array  => adc_otr_array,
         board_id       => board_id,
         crate_id       => crate_id,
         trigger        => trigger_int,
         wiz_int        => wiz_int,
         CLK_25_PS      => CLK_25_PS_internal,
         CLK_50         => CLK_50,
         RSRLOAD        => RSRLOAD,
         SRCLK          => SRCLK,
         adc_oeb        => adc_oeb,
         dac_cs         => dac_cs,
         drs_channel_id => drs_channel_id,
         drs_dwrite     => drs_dwrite,
         led            => led,
         sclk           => sclk,
         sensor_cs      => sensor_cs,
         wiz_addr       => wiz_addr,
         wiz_cs         => wiz_cs,
         wiz_rd         => wiz_rd,
         wiz_reset      => wiz_reset,
         wiz_wr         => wiz_wr,
         sio            => sio,
         wiz_data       => wiz_data
      );
   I_testboard_adc : FAD_adc_emulator
      PORT MAP (
         adc_oeb  => adc_oeb,
         clk      => CLK_25_PS_internal,
         rst      => rst,
         adc_data => adc_data,
         adc_otr  => adc_otr
      );
   I_testboard_debouncer : debouncer
      GENERIC MAP (
         WIDTH => 12
      )
      PORT MAP (
         clk         => CLK_25_PS_internal,
         trigger_in  => trigger,
         trigger_out => trigger_int
      );
   I0 : max6662_emulator
      GENERIC MAP (
         DRS_TEMPERATURE => 51
      )
      PORT MAP (
         sclk      => sclk,
         sio       => sio,
         sensor_cs => sensor_cs
      );

   -- Implicit buffered output assignments
   CLK_25_PS <= CLK_25_PS_internal;

END struct;
