--
-- VHDL Architecture FACT_FAD_test_devices_lib.ROM_from_file.beha
--
-- Created:
--          by - FPGA_Developer.UNKNOWN (EEPC8)
--          at - 09:21:32 22.01.2010
--
-- using Mentor Graphics HDL Designer(TM) 2008.1 (Build 17)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.numeric_std.all;
USE ieee.std_logic_textio.all;
LIBRARY std;
USE std.textio.all;
LIBRARY FACT_FAD_test_devices_lib;
USE FACT_FAD_test_devices_lib.drs4_pack.all;

ENTITY ROM_from_File IS
   GENERIC( 
      INPUT_FILE : STRING  := "filename";
      WIDTH      : INTEGER := 13;       -- Breite des Datenworts
      DEPTH      : INTEGER := 1024      -- Tiefe des ROM - Speichers
   );
   PORT( 
      addr : IN     std_logic_vector (ld(DEPTH)-1 DOWNTO 0);
      dout : OUT    std_logic_vector (WIDTH-1 DOWNTO 0)
   );

-- Declarations

END ROM_from_File ;

ARCHITECTURE beha OF ROM_from_File IS

-- ROMTYPE muss wg. HREAD ein Vielfaches von 4 Bit sein, Berechnung erfolgt in 'drs4_pack'
  TYPE ROMTYPE is array(0 to DEPTH) of std_logic_vector(hexalign(WIDTH)-1 downto 0);
  
  -- InitRomFromFile liest eine Zeile aus der angegebenen Datei und legt diesen Wert in 
  -- 'ROM(i)' ab
  impure function InitRomFromFile (RomFileName : in STRING) return ROMTYPE is
    FILE RomFile : text open read_mode is RomFileName;
    variable RomFileLine : LINE;
    variable ROM : ROMTYPE;
  begin
    for i in 0 to DEPTH-1 loop
      READLINE(RomFile, RomFileLine);
      HREAD(RomFileLine, ROM(i));
    end loop;
    return ROM;
  end function InitRomFromFile;
  
  signal ROM : ROMTYPE := InitRomFromFile(INPUT_FILE);
  
BEGIN
  
  -- nur die unteren WIDTH Bits werden ausgegeben
  dout <= std_logic_vector(ROM(to_integer(unsigned(addr)))(WIDTH-1 downto 0));
  
END ARCHITECTURE beha;

