----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    10:44:52 01/07/2010 
-- Design Name: 
-- Module Name:    adc_emulator - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
-- hds interface_start
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;

ENTITY adc_emulator IS
   PORT( 
      clk      : IN     STD_LOGIC;
      reset    : IN     STD_LOGIC;
      d        : OUT    STD_LOGIC_VECTOR (11 DOWNTO 0);
      otr      : OUT    STD_LOGIC;
      oeb      : IN     STD_LOGIC;
      rom_data : IN     STD_LOGIC_VECTOR (12 DOWNTO 0);
      rom_addr : OUT    STD_LOGIC_VECTOR (9 DOWNTO 0)
   );

-- Declarations

END adc_emulator ;
-- hds interface_end

architecture Behavioral of adc_emulator is
	
	type shift_reg is array (0 to 7) of STD_LOGIC_VECTOR(12 DOWNTO 0);
	
	signal rom_reg : shift_reg;
	signal temp_addr : STD_LOGIC_VECTOR(9 downto 0) := (others => '0') ;
	
begin

  rom_addr <= temp_addr;
  d <= rom_reg(7)(11 downto 0) when oeb = '0' else (others => 'Z');
  otr <= rom_reg(7)(12);

	fetch_data_proc: process(clk, reset)
	begin
		if (reset = '1') then
			temp_addr <= (others => '0');
		elsif rising_edge(clk) then
		  if (oeb = '0') then
			  temp_addr <= STD_LOGIC_VECTOR(UNSIGNED(temp_addr) + TO_UNSIGNED(1,10));
			else
			  temp_addr <= (others => '0');    
			end if;
		end if;
	end process fetch_data_proc;
  
	
	ad_conv_proc: process(clk, reset)
	begin
		if (reset = '1') then
			for i in 0 to 7 loop
				rom_reg(i) <= (others => '0');
			end loop;
		elsif rising_edge(clk) then
		  if (oeb = '0') then
    			if (unsigned(rom_data) > 2**12-1) then
    				rom_reg(0) <= '1' & X"FFF";			-- set OTR flag when rom_data is too high and set adc value to max
    			else
    				rom_reg(0) <= rom_data;			-- shifting input cause output is shifted 7 cycles
    			end if;
    			rom_reg(1) <= rom_reg(0);
    			rom_reg(2) <= rom_reg(1);
    			rom_reg(3) <= rom_reg(2);
    			rom_reg(4) <= rom_reg(3);
    			rom_reg(5) <= rom_reg(4);
    			rom_reg(6) <= rom_reg(5);
       rom_reg(7) <= rom_reg(6);
  			end if;
		end if;
	end process ad_conv_proc;
	
end Behavioral;

