----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    10:38:03 01/11/2010 
-- Design Name: 
-- Module Name:    drs4_emulator - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
-- hds interface_start
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.NUMERIC_STD.ALL;
library FACT_FAD_test_devices_lib;
use FACT_FAD_test_devices_lib.drs4_pack.all;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;
ENTITY drs4_emulator IS
   PORT( 
      analog_in      : IN     TYPE_analog_data;
      wsrout         : OUT    STD_LOGIC;
      srout          : OUT    STD_LOGIC;
      srin           : IN     STD_LOGIC;
      srclk          : IN     STD_LOGIC;
      rsrload        : IN     STD_LOGIC;
      a              : IN     STD_LOGIC_VECTOR (3 DOWNTO 0);
      reset          : IN     STD_LOGIC;
      analog_out     : OUT    TYPE_analog_data;
      analog_addr    : OUT    TYPE_analog_addr;
      dtap           : OUT    STD_LOGIC;
      refclk         : IN     STD_LOGIC;
      pllout         : OUT    STD_LOGIC;
      dspeed         : IN     STD_LOGIC;
      dwrite         : IN     STD_LOGIC;
      denable        : IN     STD_LOGIC;
      wsrin          : IN     STD_LOGIC;
      stop_cell_reg  : IN     std_logic_vector (9 DOWNTO 0);
      stop_cell_addr : OUT    std_logic_vector (9 DOWNTO 0);
      clk_50MHz      : IN     std_logic
   );

-- Declarations

END drs4_emulator ;
-- hds interface_end

architecture Behavioral of drs4_emulator is

	signal temp_addr : TYPE_analog_addr;
	signal temp_dtap : std_logic := '1';
	signal temp_stop_addr : std_logic_vector(9 downto 0);
  signal stop_state : srout_state := SROUT_IDLE;
  signal dtap_cnt : std_logic_vector(5 downto 0);

begin
	
	analog_addr(0) <= temp_addr(0);
	analog_addr(1) <= temp_addr(1);
	analog_addr(2) <= temp_addr(2);
	analog_addr(3) <= temp_addr(3);
	analog_addr(4) <= temp_addr(4);
	analog_addr(5) <= temp_addr(5);
	analog_addr(6) <= temp_addr(6);
	analog_addr(7) <= temp_addr(7);
	analog_addr(8) <= temp_addr(8);
	
	stop_cell_addr <= temp_stop_addr;
  dtap <= temp_dtap;
  
  dtap_out_proc: process(clk_50MHz, reset, denable)
  begin
    if (reset = '0') then
      temp_dtap <= '0';
      dtap_cnt <= (others => '0');
    elsif rising_edge(clk_50MHz) then
      if (denable = '1') then
        dtap_cnt <= std_logic_vector(unsigned(dtap_cnt) + to_unsigned(1,6));
        if (unsigned(dtap_cnt) = 24) then
          temp_dtap <= not temp_dtap;
          dtap_cnt <= (others => '0');
        end if;
      end if;
    end if;
  end process dtap_out_proc;

	write_stop_cell_proc: process(reset, rsrload, srclk, stop_cell_reg)
	begin
	  if (reset = '0') then
	    temp_stop_addr <= (others => '0');
	    srout <= '0';
	    stop_state <= SROUT_IDLE;
	  elsif (rsrload = '1') then
      stop_state <= SROUT_BIT9;
      srout <= stop_cell_reg(9);
	  elsif falling_edge(srclk) then
      case stop_state is
        when SROUT_BIT9 =>
          stop_state <= SROUT_BIT8;
          srout <= stop_cell_reg(8);
        when SROUT_BIT8 =>
          stop_state <= SROUT_BIT7;
          srout <= stop_cell_reg(7);
        when SROUT_BIT7 =>
          stop_state <= SROUT_BIT6;
          srout <= stop_cell_reg(6);
        when SROUT_BIT6 =>
          stop_state <= SROUT_BIT5;
          srout <= stop_cell_reg(5);
        when SROUT_BIT5 =>
          stop_state <= SROUT_BIT4;
          srout <= stop_cell_reg(4);
        when SROUT_BIT4 =>
          stop_state <= SROUT_BIT3;
          srout <= stop_cell_reg(3);
        when SROUT_BIT3 =>
          stop_state <= SROUT_BIT2;
          srout <= stop_cell_reg(2);
        when SROUT_BIT2 =>
          stop_state <= SROUT_BIT1;
          srout <= stop_cell_reg(1);
        when SROUT_BIT1 =>
          stop_state <= SROUT_BIT0;
          srout <= stop_cell_reg(0);
        when SROUT_BIT0 =>
           srout <= '0';
           temp_stop_addr <= std_logic_vector(unsigned(temp_stop_addr) + to_unsigned(1,10));
           stop_state <= SROUT_IDLE;
        when others =>
      end case;
	  end if; 
	end process write_stop_cell_proc;
	
	
	analog_out_proc: process (srclk, reset, rsrload)
	begin
		if (reset = '0') then
			for i in 0 to 8 loop
				temp_addr(i) <= (others => '0');
--        temp_addr(i) <= stop_cell_reg;
				analog_out(i) <= (others => 'Z');
			end loop;
		elsif rising_edge(srclk) then
		  if (dwrite = '0') then	
      			case a is
      				when "0000" =>
        					analog_out(8) <= analog_in(0);
        					temp_addr(0) <= std_logic_vector(unsigned(temp_addr(0)) + to_unsigned(1,10));
      				when "0001" =>
        					analog_out(8) <= analog_in(1);
        					temp_addr(1) <= std_logic_vector(unsigned(temp_addr(1)) + to_unsigned(1,10));
      				when "0010" =>
        					analog_out(8) <= analog_in(2);
        					temp_addr(2) <= std_logic_vector(unsigned(temp_addr(2)) + to_unsigned(1,10));
      				when "0011" =>
             analog_out(8) <= analog_in(3);
        					temp_addr(3) <= std_logic_vector(unsigned(temp_addr(3)) + to_unsigned(1,10));
      				when "0100" =>
        					analog_out(8) <= analog_in(4);
        					temp_addr(4) <= std_logic_vector(unsigned(temp_addr(4)) + to_unsigned(1,10));
      				when "0101" =>
        					analog_out(8) <= analog_in(5);
        					temp_addr(5) <= std_logic_vector(unsigned(temp_addr(5)) + to_unsigned(1,10));
      				when "0110" =>
        					analog_out(8) <= analog_in(6);
        					temp_addr(6) <= std_logic_vector(unsigned(temp_addr(6)) + to_unsigned(1,10));
      				when "0111" =>
        					analog_out(8) <= analog_in(7);
        					temp_addr(7) <= std_logic_vector(unsigned(temp_addr(7)) + to_unsigned(1,10));
      				when "1000" =>
        					analog_out(8) <= analog_in(8);
        					temp_addr(8) <= std_logic_vector(unsigned(temp_addr(8)) + to_unsigned(1,10));
      				when "1001" =>
        					for i in 0 to 8 loop
          						analog_out(i) <= analog_in(i);
          						temp_addr(i) <= std_logic_vector(unsigned(temp_addr(i)) + to_unsigned(1,10));
        					end loop;
      				when "1111" =>
        					for i in 0 to 8 loop
          						analog_out(i) <= (others => 'Z');
        					end loop;
      				when others =>
      			end case;
   			end if;
		end if;
	end process analog_out_proc;
	
end Behavioral;

