--
-- VHDL Package Header FACT_FAD_test_devices_lib.drs4_pack
--
-- Created:
--          by - Benjamin Krumm.UNKNOWN (EEPC8)
--          at - 10:42:57 20.01.2010
--
-- using Mentor Graphics HDL Designer(TM) 2008.1 (Build 17)
--
--	Package File Template
--
--	Purpose: This package defines supplemental types, subtypes, 
--		 constants, and functions 


library IEEE;
use IEEE.STD_LOGIC_1164.all;
--use IEEE.math_real.all;

package drs4_pack is

  type TYPE_analog_data is array (0 to 8) of STD_LOGIC_VECTOR(12 downto 0);
  type TYPE_analog_addr is array (0 to 8) of STD_LOGIC_VECTOR(9 downto 0);
  type TYPE_data_ROM is array (0 to 8) of STD_LOGIC_VECTOR(12 downto 0); 

  type srout_state is ( SROUT_IDLE, SROUT_BIT9, SROUT_BIT8, SROUT_BIT7,
                        SROUT_BIT6, SROUT_BIT5, SROUT_BIT4, SROUT_BIT3,
                        SROUT_BIT2, SROUT_BIT1, SROUT_BIT0 );

  function ld (m : POSITIVE) return natural;
  function hexalign (m : POSITIVE) return natural;
  
end drs4_pack;

package body drs4_pack is
  
  function ld (m : POSITIVE) return NATURAL is
  begin
    for n in 0 to integer'high loop
      if (2**n >= m) then
        return n;
      end if;
    end loop;
  end function ld;

  function hexalign (m : POSITIVE) return NATURAL is
  begin
    for n in 0 to integer'high loop
      if (n * 4 > m) then
        return m + ((n * 4) - m);
      end if;
    end loop;
  end function hexalign;
  
end package body;