-- VHDL Entity FACT_FAD_test_devices_lib.FAD_adc_emulator.symbol
--
-- Created:
--          by - kai.UNKNOWN (E5PCXX)
--          at - 12:09:56 04.05.2010
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.1 (Build 12)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

ENTITY FAD_adc_emulator IS
   PORT( 
      adc_oeb  : IN     STD_LOGIC;
      clk      : IN     STD_LOGIC;
      rst      : IN     STD_LOGIC;
      adc_data : OUT    STD_LOGIC_VECTOR (11 DOWNTO 0);
      adc_otr  : OUT    STD_LOGIC
   );

-- Declarations

END FAD_adc_emulator ;

--
-- VHDL Architecture FACT_FAD_test_devices_lib.FAD_adc_emulator.struct
--
-- Created:
--          by - kai.UNKNOWN (E5PCXX)
--          at - 12:09:56 04.05.2010
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.1 (Build 12)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE IEEE.NUMERIC_STD.ALL;
USE ieee.std_logic_textio.all;
LIBRARY std;
USE std.textio.all;
LIBRARY FACT_FAD_test_devices_lib;
USE FACT_FAD_test_devices_lib.drs4_pack.all;

LIBRARY FACT_FAD_test_devices_lib;

ARCHITECTURE struct OF FAD_adc_emulator IS

   -- Architecture declarations

   -- Internal signal declarations
   SIGNAL rom_addr : STD_LOGIC_VECTOR(9 DOWNTO 0);
   SIGNAL rom_data : STD_LOGIC_VECTOR(12 DOWNTO 0);


   -- Component Declarations
   COMPONENT ROM_from_File
   GENERIC (
      INPUT_FILE : STRING  := "filename";
      WIDTH      : INTEGER := 13;       -- Breite des Datenworts
      DEPTH      : INTEGER := 1024      -- Tiefe des ROM - Speichers
   );
   PORT (
      addr : IN     std_logic_vector (ld(DEPTH)-1 DOWNTO 0);
      dout : OUT    std_logic_vector (WIDTH-1 DOWNTO 0)
   );
   END COMPONENT;
   COMPONENT adc_emulator
   PORT (
      clk      : IN     STD_LOGIC ;
      reset    : IN     STD_LOGIC ;
      d        : OUT    STD_LOGIC_VECTOR (11 DOWNTO 0);
      otr      : OUT    STD_LOGIC ;
      oeb      : IN     STD_LOGIC ;
      rom_data : IN     STD_LOGIC_VECTOR (12 DOWNTO 0);
      rom_addr : OUT    STD_LOGIC_VECTOR (9 DOWNTO 0)
   );
   END COMPONENT;

   -- Optional embedded configurations
   -- pragma synthesis_off
   FOR ALL : ROM_from_File USE ENTITY FACT_FAD_test_devices_lib.ROM_from_File;
   FOR ALL : adc_emulator USE ENTITY FACT_FAD_test_devices_lib.adc_emulator;
   -- pragma synthesis_on


BEGIN

   -- Instance port mappings.
   I_adc_ROM : ROM_from_File
      GENERIC MAP (
         INPUT_FILE => "D:\kai\FPGA\FACT_FAD\memory_files\analog_input_ch0.txt",
         WIDTH      => 13,                                                     -- Breite des Datenworts
         DEPTH      => 1024                                                    -- Tiefe des ROM - Speichers
      )
      PORT MAP (
         addr => rom_addr,
         dout => rom_data
      );
   I_adc_controller : adc_emulator
      PORT MAP (
         clk      => clk,
         reset    => rst,
         d        => adc_data,
         otr      => adc_otr,
         oeb      => adc_oeb,
         rom_data => rom_data,
         rom_addr => rom_addr
      );

END struct;
