--
-- VHDL Architecture FACT_FAD_TB_lib.spi_devices_emulator.beha
--
-- Created:
--          by - Benjamin Krumm.UNKNOWN (EEPC8)
--          at - 09:26:11 28.04.2010
--
-- using Mentor Graphics HDL Designer(TM) 2009.1 (Build 12)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
--LIBRARY FACT_FAD_lib;
--USE FACT_FAD_lib.fad_definitions.all;

ENTITY spi_devices_emulator IS
   PORT( 
      sclk         : IN     std_logic;
      sio          : INOUT  std_logic;
      dac_cs       : IN     std_logic;
      sensor_cs    : IN     std_logic_vector (3 DOWNTO 0)
--      sensor_ready : IN     std_logic;
--      config_ready : IN     std_logic;
--      config_start : OUT    std_logic
   );

-- Declarations

END spi_devices_emulator ;

ARCHITECTURE beha OF spi_devices_emulator IS

  type TYPE_TEMPERATURE is array (0 to 3) of integer range -55 to 150;

  signal spi_read : std_logic := '0'; -- set HIGH when data should be read from SPI device
  signal sio_temp : std_logic := 'Z';
  signal command : std_logic_vector(7 downto 0) := (others => '0');
  signal data : std_logic_vector(15 downto 0) := (others => '0');
  signal cnt : integer := 0;
  signal temperature : TYPE_TEMPERATURE;
  
BEGIN
  
  sio <= sio_temp when (spi_read = '1') else 'Z';
  sio_temp <= sio when (spi_read = '0') else 'Z';
  
  spi_cnt_proc: process (sclk)
  begin
    if rising_edge(sclk) then
      if (sensor_cs /= "1111") then
        cnt <= cnt + 1;
      else
        cnt <= 0;
      end if;
    end if;
    if falling_edge(sclk) then
      if (sensor_cs /= "1111") then
        cnt <= cnt + 1;
      else
        cnt <= 0;
      end if;
    end if;
      
  end process spi_cnt_proc;
  
  spi_read <= '1' when (cnt > 16) else '0';
  temperature(0) <= 51;
  temperature(1) <= 52;
  temperature(2) <= 53;
  temperature(3) <= 54;

  sensor_data_proc: process (cnt, sclk)
  begin
    if (cnt = 0) then
      case sensor_cs is
        when "1110" =>
          data <= '0' & conv_std_logic_vector(temperature(0),12) & "000";   
        when "1101" =>
          data <= '0' & conv_std_logic_vector(temperature(1),12) & "000";
        when "1011" =>
          data <= '0' & conv_std_logic_vector(temperature(2),12) & "000";
        when "0111" =>
          data <= '0' & conv_std_logic_vector(temperature(3),12) & "000";
        when others =>
          data <= '0' & conv_std_logic_vector(0,12) & "000";
      end case;
    end if;
    if falling_edge(sclk) then
      if (cnt > 15) then
        sio_temp <= data(15);
        data(15 downto 1) <= data(14 downto 0);
      end if;
    end if;
  end process sensor_data_proc;
  
--  temperature_proc: process
--  begin
--    temperature(0) <= 51;
--    temperature(1) <= 52;
--    temperature(2) <= 53;
--    temperature(3) <= 54;
--    wait for 1.5 ms;
--    temperature(0) <= 61;
--    temperature(1) <= 62;
--    temperature(2) <= 63;
--    temperature(3) <= 64;
--    wait for 1.5 ms;
--    temperature(0) <= 71;
--    temperature(1) <= 72;
--    temperature(2) <= 73;
--    temperature(3) <= 74;
--    wait;
--  end process temperature_proc;
  
  -- start DAC configuration
--  config_start_proc: process
--  begin
--    config_start <= '0';
--    wait for 100 us;
--    config_start <= '1';
--    wait until (config_ready = '1');
--    config_start <= '0';
--    
--    -- start config before temperature should be measured
--    wait for 3.75 ms;
--    config_start <= '1';
--    wait until (config_ready = '1');
--    config_start <= '0';
--    
--    -- start config while temperature is measured
--    wait for 3.96 ms;
--    config_start <= '1';
--    wait until (config_ready = '1');
--    config_start <= '0';
--
--    -- start configuration at the absolute same time as temp. measurement
--    wait for 3.837 ms;
--    config_start <= '1';
--    wait until (config_ready = '1');
--    config_start <= '0';
--
--    wait;
--  end process config_start_proc;

END ARCHITECTURE beha;

