/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  12/2000 (tbretz@uni-sw.gwdg.de)
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

Bool_t HandleInput()
{
    TTimer timer("gSystem->ProcessEvents();", 50, kFALSE);
    while (1)
    {
        //
        // While reading the input process gui events asynchronously
        //
        timer.TurnOn();
        TString input = Getline("Type 'q' to exit, <return> to go on: ");
        timer.TurnOff();

        if (input=="q\n")
            return kFALSE;

        if (input=="\n")
            return kTRUE;
    };

    return kFALSE;
}

void readCT1(const char *fname="~/data/CT1_97_on1.dat")
{
    MParList plist;

    MGeomCamCT1  geomcam;
    MHillas      hillas;
    MHillasExt   hillasext;
    MNewImagePar newimgpar;
    MTaskList    tlist;

    plist.AddToList(&geomcam);
    plist.AddToList(&hillas);
    plist.AddToList(&hillasext);
    plist.AddToList(&newimgpar);
    plist.AddToList(&tlist);

    MCT1ReadAscii read(fname);
    MClone        clone("MCerPhotEvt");
    MImgCleanStd  clean;
    MHillasCalc   hcalc;

    tlist.AddToList(&read);
    tlist.AddToList(&clone);
    tlist.AddToList(&clean);
    tlist.AddToList(&hcalc);

    MEvtLoop evtloop;
    evtloop.SetParList(&plist);

    if (!evtloop.PreProcess())
        return;

    Int_t icount = 0;
    MCamDisplay display(&geomcam);
    display.Draw();

    while ((rc=tlist.Process()))
    {
        cout << "Event #" << icount++ << endl;

        MCerPhotEvt *evt = (MCerPhotEvt*)clone.GetClone();
        if (!evt)      // If skipped due to MInputStreamId
            continue;

        display.FillPhotNum(*evt);
        display.Update();

        if (!HandleInput())
            break;

        hillas.Draw();
        hillas.Print();
        hillasext.Print();
        newimgpar.Print();

        display.FillPhotNum(*(MCerPhotEvt*)plist.FindObject("MCerPhotEvt"));
        display.Update();

        if (!HandleInput())
            break;
    } 

    evtloop.PostProcess();
}
