/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz, 6/2003 <mailto:tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2003
!
!
\* ======================================================================== */

// -------------------------------------------------------------------------
//
//  plot.C
//
//  This macro shows how to fill and display a histogram using Mars
//
void sumcurrents(const char *fname="../currents/dcs_arcturus.dat")
{
    //
    // Create a empty Parameter List and an empty Task List
    // The tasklist is identified in the eventloop by its name
    //
    MParList  plist;

    MTaskList tlist;
    plist.AddToList(&tlist);

    //
    // Now setup the tasks and tasklist:
    // ---------------------------------
    //

    MGeomCamMagic geom;
    plist.AddToList(&geom);

    // First Task: Read file with image parameters
    // (created with the star.C macro)
    MReadCurrents read(fname);
    /*
     read.AddFile("../currents/dcs_arcturus2.dat");
     read.AddFile("../currents/dcs_arcturus3.dat");
     read.AddFile("../currents/dcs_arcturus4.dat");
     read.AddFile("../currents/dcs_arcturus5.dat");
     read.AddFile("../currents/dcs_arcturus6.dat");
     read.AddFile("../currents/dcs_arcturus7.dat");
     read.AddFile("../currents/dcs_arcturus8.dat");
     read.AddFile("../currents/dcs_arcturus9.dat");
     read.AddFile("../currents/dcs_arcturus10.dat");
     */
    tlist.AddToList(&read);

    MFillH fill("MHCurrents");
    tlist.AddToList(&fill);

    //
    // Create and setup the eventloop
    //
    MEvtLoop evtloop;
    evtloop.SetParList(&plist);

    //
    // Execute your analysis
    //
    if (!evtloop.Eventloop())
        return;

    tlist.PrintStatistics();

    MHCurrents &h = *(MHCurrents*)plist->FindObject("MHCurrents");

    MCamDisplay *disp = new MCamDisplay(&geom);
    disp->FillCurrents(h.GetSum());
    disp->Draw();
}
