#ifndef EVIDENCE_H_SEEN
#define EVIDENCE_H_SEEN

#include <stdio.h>
#include <stdarg.h>
#include <string>
#include <errno.h>
#include <vector>
#include <exception>
#include <cxxabi.h>

#include "dis.hxx"
#include "dic.hxx"

#define NO_LINK (char *) "__&DIM&NOLINK&__" // Data if no link available
#define STATUS_SIZE 1000					// Bytes for status service string
#define EVIDENCE_REVISION "$Revision: 216 $"

// Class declation of Evidence server
class EvidenceServer: public DimServer {
  private:
	// This class will contain in LastModifyTime always
	// the unix time of the last config file update 
	class ConfigUpdate: public DimClient {
	  DimInfo *ModifyInfo;
	  
	  public:
	    ConfigUpdate() {
	      LastModifyTime = 0;
		  ModifyInfo = new DimInfo("Config/ModifyTime", NO_LINK, this);
	    }
		~ConfigUpdate() {
		  delete ModifyInfo;
		}
	    void infoHandler(){
	      if (EvidenceServer::ServiceOK(getInfo())) LastModifyTime = getInfo()->getInt();
	    }
		int LastModifyTime;
	};

	struct ConfigItem {
	  std::string Name;
	  char *Value;
	  int Time;
	};
	std::vector<struct ConfigItem> ConfigList;

	std::string ServerName;
    DimService *Status, *StdOut;
	class ConfigUpdate *ModifyInfo;
	
	char InitMsg[STATUS_SIZE];
	int LastModifyTime;
	char *StdOutText;
	
    static void SignalHandler(int); // static for signal()
    static void Terminate();  		// static for set_terminate()
	void errorHandler(int, int, char *);
	void exitHandler(int);
	
  public:
    EvidenceServer(const char *);
	~EvidenceServer();

	enum MessageType {INFO=0, WARN=1, ERROR=2, FATAL=3};

	void Message(MessageType, const char *, ...);
	void SetStdOut(char *);
	char* GetConfig(std::string, const char * = NULL);
	static char* ToString(DimInfo *);
	static bool ServiceOK(DimInfo *);
	static bool ServiceOK(DimRpcInfo *);

    bool ExitRequest;
};

class EvidenceHistory {

  public:  
  	struct Item {
	  int Time;
	  int Size;
	  char Data[]; // Size bytes
	} __attribute__((packed));

	static const struct Item WrapMark;
	static const struct Item EndMark;

  private:
	std::string Name;
	char *Buffer;
	int BufferSize;
	struct Item *Pointer;
	
  public:
	EvidenceHistory(std::string);
	~EvidenceHistory();	

	bool GetHistory();
	const struct Item *Next();
	void Rewind();
};
#endif
