#ifndef MARS_MRawEvtData
#define MARS_MRawEvtData

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

// gcc 3.2
//class ifstream;
#include <iosfwd>

class MRawRunHeader;

class TArrayC;
class MArrayS;
class MArrayB;

class MRawEvtData : public MParContainer
{
    friend class MRawEvtPixelIter;
private:
    MRawRunHeader *fRunHeader;    //! provides information about numbers

    // FIXME: COMMENT ABOUT ORDERING

    MArrayS *fHiGainPixId;        // list of pixel IDs of hi gain channel
    MArrayB *fHiGainFadcSamples;  // list of hi gain samples of all pixels (ordering: see fHiGainPixId)

    MArrayS *fLoGainPixId;        // list of pixel IDs of lo gain channel
    MArrayB *fLoGainFadcSamples;  // list of lo gain samples of all pixels (ordering: see fLoGainPixId)

    Int_t fPosInArray;   //!
    Int_t fArraySize;    //!

    void InitArrays(Bool_t flag=kFALSE);
    void DeleteArrays();

public:
    MRawEvtData(const char *name=NULL, const char *title=NULL);
    ~MRawEvtData();

    void Init(MRawRunHeader *rh)
    {
        //
        // you have to set this before you can read information
        // from a magic binary file
        //
        fRunHeader = rh;
    }

    void Clear(Option_t * = NULL);
    void Print(Option_t * = NULL) const;
    void Draw (Option_t * = NULL);

    void DeletePixels(Bool_t flag=kFALSE);
    void ResetPixels() { DeletePixels(kTRUE); }
    void AddPixel(UShort_t nOfPixel, TArrayC *data, Bool_t lflag=kFALSE);

    Byte_t   GetNumHiGainSamples() const;
    Byte_t   GetNumLoGainSamples() const;
    UShort_t GetNumPixels() const;

    void ReadEvt(istream &fin);

    ClassDef(MRawEvtData, 1) //Container to store the raw Event Data
};

#endif
