/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  12/2000 <mailto:tbretz@uni-sw.gwdg.de>
!   Author(s): Harald Kornmayer 1/2001 
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

//////////////////////////////////////////////////////////////////////////////
//
//  MDumpEvtHeader
//
//  Print out some event header information to the screen. This maybe useful
//  if you are not sure what the events in the file conatins or you
//  want to check for the contents.
//
//  Input Containers:
//   MRawEvtHeader, MRawEvtData
//
//  Output Containers:
//   -/-
//
//////////////////////////////////////////////////////////////////////////////

#include "MDumpEvtHeader.h"

#include "MLog.h"
#include "MLogManip.h"

#include "MParList.h"
#include "MRawEvtHeader.h"
#include "MRawEvtPixelIter.h"

ClassImp(MDumpEvtHeader);

using namespace std;

// --------------------------------------------------------------------------
//
// Preprocessing of class. Check for the two container which should
// get printed by the Process-function: MRawEvtHeader and MRawEvtData.
// If one of the two doesn't exist (input containers) stop processing of
// data.
//
Bool_t MDumpEvtHeader::PreProcess (MParList *pList)
{
    fRawEvtHeader = (MRawEvtHeader*)pList->FindObject("MRawEvtHeader");
    if (!fRawEvtHeader)
    {
        *fLog << err << dbginf << "- Error: MRawEvtHeader not found... exit." << endl;
        return kFALSE;
    }

    fRawEvtData = (MRawEvtData*)pList->FindObject("MRawEvtData");
    if (!fRawEvtData)
    {
        *fLog << err << dbginf << "- Error: MRawEvtData not found... exit." << endl;
        return kFALSE;
    }

    return kTRUE ;
} 

// --------------------------------------------------------------------------
//
// Print out information of the actual event (header) and print the
// pixel ID's of all pixels in this event.
//
Bool_t MDumpEvtHeader::Process()
{
    fRawEvtHeader->Print();

    *fLog << all;

    MRawEvtPixelIter pixel(fRawEvtData);

    while (pixel.Next())
        *fLog << " " << pixel.GetPixelId();

    *fLog << endl;

    return kTRUE;
}
