#ifndef MARS_MRawFileRead
#define MARS_MRawFileRead

#ifndef MARS_MTask
#include "MTask.h"
#endif

// gcc 3.2
//class ifstream;
#include <iosfwd>

class MTime;
class MParList;
class MRawRunHeader;
class MRawEvtHeader;
class MRawEvtData;
class MRawCrateArray;

class MRawFileRead : public MTask
{
private:
    MRawRunHeader  *fRawRunHeader;  // run header information container to fill from file
    MRawEvtHeader  *fRawEvtHeader;  // event header information container to fill from file
    MRawEvtData    *fRawEvtData;    // raw evt header infomation container to fill from file
    MRawCrateArray *fRawCrateArray; // crate information array container to fill from file
    MTime          *fRawEvtTime;    // raw evt time information container to fill from file

    TString         fFileName;
    ifstream       *fIn;            //! buffered input stream (file to read from)

public:
    MRawFileRead(const char *filename, const char *name=NULL, const char *title=NULL);
    ~MRawFileRead();

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t PostProcess();

    ClassDef(MRawFileRead, 0)	// Task to read the raw data binary file
};

#endif
