/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz, 5/2003 <mailto:tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2003
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
// MRflEvtData
//
// All Photons of a event from the reflector program
//
// Should be filled like this:
//   MRflEvtData evt;
//   evt.Reset();
//   for (int i=0; i<10; i++)
//      MRflSinglePhoton &ph = evt.GetNewPhoton();
//   evt.FixSize();
//
/////////////////////////////////////////////////////////////////////////////
#include "MRflEvtData.h"

#include "MLog.h"
#include "MLogManip.h"

ClassImp(MRflEvtData);

using namespace std;

// --------------------------------------------------------------------------
//
// Creates a MCerPhotPix object for each pixel in the event
//
MRflEvtData::MRflEvtData(const char *name, const char *title)
   : fList("MRflSinglePhoton", 0), fPos(0)
{
    fName  = name  ? name  : "MRflEvtData";
    fTitle = title ? title : "All Photons from a reflector event";
}

// --------------------------------------------------------------------------
//
// Dump informations off all photons
//
void MRflEvtData::Print(Option_t *o) const
{
    *fLog << all << underline << GetDescriptor() << ":" << endl;
    fList.Print();
}

// --------------------------------------------------------------------------
//
// Add a new photon to the list
//
MRflSinglePhoton &MRflEvtData::GetNewPhoton()
{
    // If necessary the []-operator creates a new element
    // Warning: The virtual table may not be set correctly,
    //          this is why you have to call the new-operator.
    return *new (fList[fPos++]) MRflSinglePhoton;
}

// --------------------------------------------------------------------------
//
// If you have added all photon fix the size of the container.
//
void MRflEvtData::FixSize()
{
    if (fList.GetEntriesFast() == fPos)
        return;

    fList.ExpandCreateFast(fPos);
}

