#ifndef MARS_MCerPhotCalc
#define MARS_MCerPhotCalc

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MCerPhotCalc                                                            //
//                                                                         //
// Integrates the desired ADC time slices of one pixel and substracts the  //
// pedestal (offset) value                                                 //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
#ifndef ROOT_TArrayF
#include <TArrayF.h>
#endif

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MRawEvtData;
class MPedestalCam;
class MCerPhotEvt;
class MRawRunHeader;

class MCerPhotCalc : public MTask
{
    MPedestalCam   *fPedestals;  // Pedestals of all pixels in the camera
    MRawEvtData    *fRawEvt;     // raw event data (time slices)
    MCerPhotEvt    *fCerPhotEvt; // Cerenkov Photon Event used for calculation
    MRawRunHeader  *fRunHeader;  // RunHeader information
 
    Bool_t          fEnableFix;  // fix for a bug in files from older camera versions (<=40)

    TArrayF         fWeight;  // Weights for adding up the ADC slices
    Float_t         fSumWeights;
    Float_t         fSumQuadWeights;

    void SetDefaultWeights();

public:
    MCerPhotCalc(const char *name=NULL, const char *title=NULL);

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t ReInit(MParList *pList);

    // FIXME: The array size should be checked!
    void   SetWeights(const TArrayF &w) { fWeight = w; }

    ClassDef(MCerPhotCalc, 0)   // Task to calculate cerenkov photons from raw data
};
 

#endif
