#ifndef MARS_MCurrents
#define MARS_MCurrents

#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif

#ifndef ROOT_TArrayI
#include <TArrayI.h>
#endif

#include <iostream.h>
class MCurrents : public MCamEvent
{
private:
    /*
       "DC %s %s %02d %02d %02d %03d 577*%05d \n",
       status1, status2, hour, minute, second, ms,
       577 * pixel_DC_readout_in_nAmp
       */
    TString fStatus[2];
    TArrayI fArray; // [nA] Unsigned Int!

public:
    MCurrents(Int_t size=577, const char *name=NULL, const char *title=NULL);

    void SetCurrent(Int_t i, UInt_t val) { fArray[i] = (Int_t)val; }
    UInt_t GetCurrent(Int_t i) const { return (*this)[i]; }
    UInt_t &operator[](Int_t i) { return (UInt_t&)fArray[i]; }
    const UInt_t &operator[](Int_t i) const { return (*this)[i]; }

    UInt_t GetMin() const;
    UInt_t GetMax() const;

    void SetStatus1(const TString &str) { fStatus[0] = str; }
    void SetStatus2(const TString &str) { fStatus[1] = str; }

    void Print(Option_t *opt=NULL) const;

    Bool_t GetPixelContent(Float_t &val, Int_t idx, Float_t ratio=1, Int_t type=0) const
    {
        val = (*this)[idx];
        return val>0;
    }
    void DrawPixelContent(Int_t num) const
    {
    }

    ClassDef(MCurrents, 1) // Storage Container for the Currents (PRELIMINARY)
};

#endif
