/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz, 6/2003 <mailto:tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2003
!
!
\* ======================================================================== */

// -------------------------------------------------------------------------
//
//  plot.C
//
//  This macro shows how to fill and display a histogram using Mars
//
void sumcurrents(const char *fname="../currents/spica_center.txt")
{
    //
    // Create a empty Parameter List and an empty Task List
    // The tasklist is identified in the eventloop by its name
    //
    MParList  plist;

    MTaskList tlist;
    plist.AddToList(&tlist);

    //
    // Now setup the tasks and tasklist:
    // ---------------------------------
    //

    MGeomCamMagic geom;
    plist.AddToList(&geom);

    // First Task: Read file with image parameters
    // (created with the star.C macro)
    MReadCurrents read(fname);
    /*
     read.AddFile("../currents/dcs_arcturus2.dat");
     read.AddFile("../currents/dcs_arcturus3.dat");
     read.AddFile("../currents/dcs_arcturus4.dat");
     read.AddFile("../currents/dcs_arcturus5.dat");
     read.AddFile("../currents/dcs_arcturus6.dat");
     read.AddFile("../currents/dcs_arcturus7.dat");
     read.AddFile("../currents/dcs_arcturus8.dat");
     read.AddFile("../currents/dcs_arcturus9.dat");
     read.AddFile("../currents/dcs_arcturus10.dat");
     */
    tlist.AddToList(&read);

    MFillH fill("MHCurrents");
    tlist.AddToList(&fill);

    //
    // Create and setup the eventloop
    //
    MEvtLoop evtloop;
    evtloop.SetParList(&plist);

    //
    // Execute your analysis
    //
    if (!evtloop.Eventloop())
        return;

    tlist.PrintStatistics();

    MHCurrents &h = *(MHCurrents*)plist->FindObject("MHCurrents");

    TCanvas *c = MH::MakeDefCanvas();
    c->Divide(3, 2);

    MCamDisplay *disp1=new MCamDisplay(&geom);
    MCamDisplay *disp2=new MCamDisplay(&geom);
    MCamDisplay *disp3=new MCamDisplay(&geom);
    disp1->Fill(h.GetSum());
    disp2->Fill(h.GetRms());

    TArrayF arr(577);
    for (int i=0;i<577;i++)
    {
        TArrayF &r = h.GetRms();
        TArrayF &v = h.GetSum();
        arr[i] = (r[i]==0 ? 0 : v[i]/r[i]);
    }
    disp3->Fill(arr);

    c->cd(1);
    gPad->SetBorderMode(0);
    gPad->Divide(1,1);
    gPad->cd(1);
    gPad->SetLogz();
    disp1->Draw();
    disp1->SetBit(kCanDelete);
    c->cd(2);
    gPad->SetBorderMode(0);
    gPad->Divide(1,1);
    gPad->cd(1);
    gPad->SetLogz();
    disp2->Draw();
    disp2->SetBit(kCanDelete);
    c->cd(3);
    gPad->SetBorderMode(0);
    gPad->Divide(1,1);
    gPad->cd(1);
    gPad->SetLogz();
    disp3->Draw();
    disp3->SetBit(kCanDelete);
    c->cd(4);
    gPad->SetBorderMode(0);
    h.GetHist().DrawClone();
    c->cd(5);
    gPad->SetBorderMode(0);
    TH1F h1("currents;rms", "Currents Rms", 577, -0.5, 576.5);
    for (int i=1;i<=577; i++)
        h1.SetBinContent(i, h.GetHist().GetBinError(i));
    h1.DrawCopy();
    c->cd(6);
    gPad->SetBorderMode(0);
    TH1F h2("currents;relerr", "Currents rel. Error [%]", 577, -0.5, 576.5);
    for (int i=1;i<=577; i++)
    {
        Float_t val = h.GetHist().GetBinContent(i);
        Float_t rms = h.GetHist().GetBinError(i);
        h2.SetBinContent(i, rms==0?0:val/rms);
    }
    h2.DrawCopy();

    c->SaveAs("spica_center-avg.ps");
}
