/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz, 6/2003 <mailto:tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2003
!
!
\* ======================================================================== */

void ProcessFile(TString fname)
{
    //
    // Create a empty Parameter List and an empty Task List
    // The tasklist is identified in the eventloop by its name
    //
    MParList  plist;

    MTaskList tlist;
    plist.AddToList(&tlist);

    //
    // Now setup the tasks and tasklist:
    // ---------------------------------
    //

    MGeomCamMagic geom;
    plist.AddToList(&geom);

    // First Task: Read file with image parameters
    // (created with the star.C macro)
    MReadCurrents read(fname);
    tlist.AddToList(&read);

    MFillH fill("MHCurrents");
    tlist.AddToList(&fill);

    //
    // Create and setup the eventloop
    //
    MEvtLoop evtloop;
    evtloop.SetParList(&plist);

    //
    // Execute your analysis
    //
    if (!evtloop.Eventloop())
        return;

    tlist.PrintStatistics();

    MHCurrents &h = *(MHCurrents*)plist->FindObject("MHCurrents");

    TCanvas *c = MH::MakeDefCanvas();
    c->Divide(3, 2);

    MCamDisplay *disp1=new MCamDisplay(&geom);
    MCamDisplay *disp2=new MCamDisplay(&geom);
    MCamDisplay *disp3=new MCamDisplay(&geom);
    disp1->Fill(h.GetSum());
    disp2->Fill(h.GetRms());

    TArrayF arr(577);
    for (int i=0;i<577;i++)
    {
        TArrayF &r = h.GetRms();
        TArrayF &v = h.GetSum();
        arr[i] = (v[i]==0 ? 0 : r[i]/v[i]);
    }
    disp3->Fill(arr);

    c->cd(1);
    gPad->SetBorderMode(0);
    gPad->Divide(1,1);
    gPad->cd(1);
    gPad->SetLogz();
    disp1->Draw();
    disp1->SetBit(kCanDelete);
    c->cd(2);
    gPad->SetBorderMode(0);
    gPad->Divide(1,1);
    gPad->cd(1);
    gPad->SetLogz();
    disp2->Draw();
    disp2->SetBit(kCanDelete);
    c->cd(3);
    gPad->SetBorderMode(0);
    gPad->Divide(1,1);
    gPad->cd(1);
    gPad->SetLogz();
    disp3->Draw();
    disp3->SetBit(kCanDelete);
    c->cd(4);
    gPad->SetBorderMode(0);
    h.GetHist().SetStats(kFALSE);
    h.GetHist().DrawCopy();
    c->cd(5);
    gPad->SetBorderMode(0);
    gPad->SetLogy();
    TH1F h1("currents;rms", "Currents Rms", 577, -0.5, 576.5);
    h1.SetXTitle("Pixel Index");
    h1.SetStats(kFALSE);
    for (int i=1;i<=577; i++)
        h1.SetBinContent(i, h.GetHist().GetBinError(i));
    h1.DrawCopy();
    c->cd(6);
    gPad->SetBorderMode(0);
    gPad->SetLogy();
    TH1F h2("currents;relerr", "Currents rel. Error [%]", 577, -0.5, 576.5);
    h2.SetXTitle("Pixel Index");
    h2.SetStats(kFALSE);
    for (int i=1;i<=577; i++)
        h2.SetBinContent(i, arr[i-1]*100);
    h2.DrawCopy();

    c->SaveAs(fname(0, fname.Last('.')+1) + "ps");
    c->SaveAs(fname(0, fname.Last('.')+1) + "root");
}

// -------------------------------------------------------------------------
//
//  plot.C
//
//  This macro shows how to fill and display a histogram using Mars
//
void sumcurrents(const char *dirname="/home/MAGIC/online_data/ccdata/")
{
    MDirIter Next;
    Next.AddDirectory(dirname, "dc_*.txt", -1);

    TString fname;
    while (1)
    {
        fname = Next();
        if (fname.IsNull())
            break;

        ProcessFile(fname);
    }
}
