/*
 * $ZEL$
 */

#include "test_3100.h"

int
check_MAPSIZE(struct path* path)
{
#if SIS1100_Version < 0x20000
    switch (path->type) {
    case sis1100_subdev_remote: {
        struct sis1100_mapinfo info;
        info.space=2;
        if (ioctl(path->p, SIS1100_MAPINFO, &info)<0) {
            printf("ioctl(%s, SIS1100_MAPINFO, space=2): %s\n",
                    path->name, strerror(errno));
            printf("sizeof off_t is %d\n", sizeof(off_t));
            return -1;
        }
        path->mapsize=info.size;
        if (info.offset!=0) {
            printf("ioctl(%s, SIS1100_MAPINFO, space=2): "
                    "offset=0x%08llx (should be 0)\n",
                    path->name, info.offset);
            return -1;
        }
    }
    break;
    case sis1100_subdev_ram: {
        off_t max;
        max=lseek(path->p, 0, SEEK_END);
        if (max==(off_t)-1) {
            printf("lseek(%s, 0, SEEK_END): %s\n", path->name, strerror(errno));
            return -1;
        }
        path->mapsize=max;
    }
    break;
    /* no default */
    }
#else
    if (ioctl(path->p, SIS1100_MAPSIZE, &path->mapsize)<0) {
        printf("ioctl(%s, SIS1100_MAPSIZE): %s\n",
                path->name, strerror(errno));
        return -1;
    }
#endif

    printf("%s: mapsize=0x%x", path->name, path->mapsize);
    if (path->mapsize>=(1<<20))
        printf(" (%d MByte)", path->mapsize>>20);
    else if (path->mapsize>=(1<<10))
        printf(" (%d KByte)", path->mapsize>>10);
    printf("\n");
    switch (path->type) {
    case sis1100_subdev_remote:
        if (!path->mapsize)
            printf("%s: no map available; but no real error\n", path->name);
        else if (path->mapsize!=0x10000000) {
            printf("%s: wrong mapsize 0x%x (should be 0x10000000)\n",
                path->name, path->mapsize);
            return -1;
        }
        break;
    case sis1100_subdev_ram: break;
#if SIS1100_Version >= 0x20000
    case sis1100_subdev_ctrl:
        if (path->mapsize!=0x1000) {
            printf("%s: unexpected mapsize 0x%x (should be 0x1000)\n",
                path->name, path->mapsize);
            return -1;
        }
        break;
#endif
    case sis1100_subdev_dsp:
        if (path->mapsize) {
            printf("%s: unexpected mapsize 0x%x (dsp can not be mapped (yet))\n",
                path->name, path->mapsize);
            return -1;
        }
        break;
    default:
        printf("check_MAPSIZE: %s has unknown type %d\n",
                path->name, path->type);
        return -1;
    }

    return 0;
}
