/*
 * $ZEL$
 */

#include "test_3100.h"

int
check_r_block(struct path* path, u_int32_t start, u_int32_t max)
{
    int i, res, first, count, size;

    printf("check_r_block: max=0x%08x\n", max);

    for (i=0; i<max; i++) {
        buf[i]=i;
    }

    if (lseek(path->p, start, SEEK_SET)!=start) {
        printf("\nlseek(%s, 0x%08x, SEEK_SET): %s\n",
                path->name, start, strerror(errno));
        return -1;
    }

    for (i=0; i<max; i++) {
        res=write(path->p, buf+i, 4);
        if (res!=4) {
            printf("\nwrite(%s, start+%d): %s\n", path->name, i, strerror(errno));
            return -1;
        }
    }

    for (size=max; size<=max; size++) {
        if (lseek(path->p, start, SEEK_SET)!=start) {
            printf("\nlseek(%s, 0x%08x, SEEK_SET): %s\n",
                    path->name, start, strerror(errno));
            return -1;
        }
        for (i=0; i<size; i++) {
            buf[i]=~i;
        }
        res=read(path->p, buf, 4*size);
        if (res!=4*size) {
            u_int32_t err;
            printf("\nread(%s, ..., 4*%d): ", path->name, size);
            if (res&3) printf("res=%d\n", res);
            if (res>=0) {
                printf("res=%d (%4d)\n", res/4, size-res/4);
            } else {
                printf("%s\n", strerror(errno));
            }
            if (ioctl(path->p, SIS1100_LAST_ERROR, &err)<0) {
                printf("\nioctl(%s, LAST_ERROR): %s\n",
                    path->name, strerror(errno));
            } else {
                if (err==0x211)
                    return 0;
                else
                    printf("prot_err: 0x%x\n", err);
            }
            return -1;
        }
        first=1; count=0;
        for (i=0; i<size; i++) {
            if (buf[i]!=i) {
                if (first) {
                    printf("\n%s: check_r_block (max=%d size=%d):\n",
                            path->name, max, size);
                    first=0;
                }
                printf("[%3d]: %08x --> %08x\n", i, i, buf[i]);
                count++;
            }
        }
        if (count) return -1;
    }
    return 0;
}
