/* $ZEL: f1_map.h,v 1.4 2005/02/11 19:54:25 wuestner Exp $ */

/*
 * Copyright (c) 2004
 * 	Peter Wuestner.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _dev_pci_f1_map_h_
#define _dev_pci_f1_map_h_

struct f1_cm_regs {
        u_int32_t           version;
        u_int32_t           sr;             /* Status Register */
#define F1_DBELL_F1_ERR     0x3f000000
#define F1_DBELL_EVENTPF    0x003f0000
#define F1_DBELL_EVENT      0x00003f00

        u_int32_t           cr;             /* Control Register, 4 bit */
#define F1_SCR_DDTX         0x01    /* direct data transfer */
#define F1_SCR_SCAN         0x02    /* scan LVD front bus */
#define F1_SCR_EV_DBELL     0x04    /* single event dorbell */
#define F1_SCR_LED0         0x08    /* SIS1100opt front LED (upper) */
#define F1_SCR_LED1         0x10    /* SIS1100opt front LED (lower) */

        u_int32_t           res0C;
        u_int32_t           dd_counter;
        u_int32_t           dd_blocksz;
        u_int32_t           jtag_csr;       /* JTAG control/status */
        u_int32_t           jtag_data;      /* JTAG data */
};

struct f1_reg {
        u_int32_t ident;
        u_int32_t sc;
        u_int32_t optical_cr;
        u_int32_t dsp_sc;
        u_int32_t dummy;
};

/* bits in in_out */
#define f1_io_lemo_out1 (1<<4)
#define f1_io_lemo_out2 (1<<5)
/* clear is (io_*_out?)<<16 */
#define f1_io_lemo_in1 (1<<20)
#define f1_io_lemo_in2 (1<<21)

/* error codes */
#define f1_sis3100_re_berr        0x211 /* Bus Error */
#define f1_sis3100_re_retr        0x212 /* Retry */
#define f1_sis3100_re_atimeout    0x214 /* Arbitration timeout */

#endif
