/* $ZEL: sis1100_dsp.c,v 1.3 2005/02/11 19:54:26 wuestner Exp $ */

/*
 * Copyright (c) 2003-2004
 * 	Peter Wuestner.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "sis1100_sc.h"

#if !defined(__NetBSD__) && ! defined(__linux__)
#error Invalid or Unknown Operating System
#endif

int
sis1100_dsp_reset(struct sis1100_softc* sc, struct sis1100_fdata* fd)
{
    int error;

    if (!sc->dsp_present) return ENXIO;
    switch (sc->remote_hw) {
        case sis1100_hw_vme:
            SEM_LOCK(sc->sem_hw);
            error=sis3100writeremreg(sc, dsp_sc, sis3100_dsp_boot_ctrl, 1);
            if (!error) error=sis3100writeremreg(sc, dsp_sc, sis3100_dsp_run<<16, 1);
            SEM_UNLOCK(sc->sem_hw);
            break;
        case sis1100_hw_camac:
            SEM_LOCK(sc->sem_hw);
            error=sis5100writeremreg(sc, dsp_sc, sis5100_dsp_boot_ctrl, 1);
            if (!error) error=sis5100writeremreg(sc, dsp_sc, sis5100_dsp_run<<16, 1);
            SEM_UNLOCK(sc->sem_hw);
            break;
        default:
            return ENOTTY;
    }
/*
    if (error) {
        pINFO(sc, "dsp_reset: error=0x%x", error);
        return EIO;
    }
*/
    return error?EIO:0;
}

int
sis1100_dsp_start(struct sis1100_softc* sc, struct sis1100_fdata* fd)
{
    int error;

    if (!sc->dsp_present) return ENXIO;
    switch (sc->remote_hw) {
        case sis1100_hw_vme:
            error=sis3100writeremreg(sc, dsp_sc, sis3100_dsp_run, 0);
            break;
        case sis1100_hw_camac:
            error=sis5100writeremreg(sc, dsp_sc, sis5100_dsp_run, 0);
            break;
        default:
            return ENOTTY;
    }
    return error?EIO:0;
}

#define SHARCRAM  0x81200000
#define D48REG    0x81300000

int
sis1100_dsp_load(struct sis1100_softc* sc, struct sis1100_fdata* fd,
    struct sis1100_dsp_code* d)
{
#if 0

Unable to handle kernel paging request at virtual address 79dcc800
 printing eip:
f8adfc1f
*pde = 00000000
Oops: 0002 [#1]
PREEMPT SMP
Modules linked in: sis1100 3c59x
CPU:    0
EIP:    0060:[<f8adfc1f>]    Not tainted VLI
EFLAGS: 00010a07   (2.6.9-p01)
EIP is at sis1100_remote_reg_write+0x2f/0x60 [sis1100]
eax: 00000100   ebx: d561e000   ecx: d561e84c   edx: 79dcc000
esi: 00000001   edi: 81200400   ebp: ebe75edc   esp: ebe75ed4
ds: 007b   es: 007b   ss: 0068
Process sharc.driver (pid: 10742, threadinfo=ebe74000 task=c5ae62b0)
Stack: 0f110000 b7fe80e2 ebe75f20 f8ada56f d561e000 81300000 00000100 00000001
       00000096 d561e84c 00000019 81200400 0000110f 00000001 cb9e5000 00000000
       d561e000 f7d90ba0 d561e000 ebe75f38 f8adcdcb d561e000 f7d90ba0 ebe75f50
Call Trace:
 [<c010507f>] show_stack+0x7f/0xa0
 [<c010521f>] show_registers+0x15f/0x1e0
 [<c0105442>] die+0x102/0x190
 [<c01156a6>] do_page_fault+0x436/0x5f0
 [<c0104c69>] error_code+0x2d/0x38
 [<f8ada56f>] sis1100_dsp_load+0xff/0x162 [sis1100]
 [<f8adcdcb>] _sis1100_ioctl+0x48b/0x660 [sis1100]
 [<f8adcff8>] sis1100_ioctl+0x58/0xff [sis1100]
 [<c0168059>] sys_ioctl+0x169/0x2a0
 [<c01041ff>] syscall_call+0x7/0xb
Code: ec 08 89 74 24 04 8b 75 14 89 1c 24 8b 55 0c 8b 5d 08 85 f6 75 0f 8d 8b 4c
 08 00 00 f0 ff 8b 4c 08 00 00 78 5f 03 53 0c 8b 45 10 <89> 82 00 08 00 00 f0 83
 44 24 00 00 8b 43 0c 85 f6 8b 80 ac 00

#endif

    u_int8_t* code=d->src;
    u_int8_t v[6];
    u_int32_t addr, w0, w12;
    int error=0, i, j;

    if (!sc->dsp_present) return ENXIO;
if (sc->remote_hw!=sis1100_hw_vme) return ENXIO;

    if (d->dst%4) return EINVAL;
    if (d->size%6) return EINVAL;

    addr=d->dst+SHARCRAM;
    for (i=d->size/6; i && !error; i--) {
        for (j=0; j<6; j++) {
#ifdef __NetBSD__
            v[j]=fubyte(code);
#elif __linux__
            get_user(v[j], code);
#endif
            code++;
        }
#if 0
        pINFO("%08x %02x%02x%02x%02x%02x%02x",
                (addr-SHARCRAM)>>2,
                v[0], v[1], v[2], v[3], v[4], v[5]);
#endif
        w0=v[5]|(v[4]<<8);
        w12=(v[3] | (v[2]<<8) | (v[1]<<16) | (v[0]<<24));
        SEM_LOCK(sc->sem_hw);
        error=sis1100_remote_reg_write(sc, D48REG, w0, 1);
        error|=sis1100_remote_reg_write(sc, addr, w12, 1);
        SEM_UNLOCK(sc->sem_hw);
        addr+=4;
    }
    return error?EIO:0;
}
