/* $ZEL: sis1100_sc_linux.h,v 1.5 2004/05/27 23:10:33 wuestner Exp $ */

/*
 * Copyright (c) 2001-2004
 * 	Peter Wuestner.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _sis1100_sc_linux_h_
#define _sis1100_sc_linux_h_

#define SGL_SIZE 128
#define DMA_MAX (PAGE_SIZE*(SGL_SIZE-1))

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,14)
#define USE_SGL
#else
#error no USE_SGL
#endif
/*#undef USE_SGL*/

struct sis1100_dmabuf {
    size_t size;
    void* cpu_addr;
    dma_addr_t dma_handle;
};

struct mmapdma {
        int valid;
};

struct handlercommand {
    volatile enum handlercomm command;
    spinlock_t lock;
};

struct sis1100_softc;

struct sis1100_fdata {
    struct list_head list;
/* OS specific*/
    struct sis1100_softc* sc;
/*common*/
    struct mmapdma mmapdma;
    size_t mindmalen_r, mindmalen_w;
    enum sis1100_hw_type old_remote_hw;
    enum sis1100_subdev subdev;
    int32_t vmespace_am;
    u_int32_t vmespace_datasize;
    int fifo_mode;
    int last_prot_err;
    u_int32_t owned_irqs;
    pid_t pid;
    int sig;
};

struct sis1100_softc {
/* OS specific*/
    volatile u_int8_t *plxmembase; /* kernel virtual address */
    u_int32_t plxmemlen;           /* size */
    u_long plx_addr;               /* physical address */

    volatile u_int8_t*reg_base;    /* kernel virtual address */
    u_int32_t reg_size;            /* size */
    u_long reg_addr;               /* physical address */

    volatile u_int8_t*rem_base;    /* kernel virtual address */
    u_int32_t rem_size;            /* size */
    u_long rem_addr;               /* physical address */

    struct pci_dev *pcidev;
    int unit;
    int handler_pid;
    struct completion handler_completion;
#ifndef USE_SGL
    struct kiobuf* iobuf;
#endif
    struct sis1100_dmabuf descbuf;
    struct scatterlist sglist[SGL_SIZE];

/* OS specific definition but common use */
    struct semaphore sem_hw;         /* protects hardware */
    struct semaphore sem_fdata_list; /* protects fdata_list_head */
    spinlock_t lock_intcsr;          /* protects INTCSR of PLX */
    spinlock_t lock_doorbell;        /* protects sc.doorbell */
    spinlock_t lock_lemo_status;     /* protects sc.lemo_status */
    wait_queue_head_t handler_wait;
    wait_queue_head_t local_wait;
    wait_queue_head_t remoteirq_wait;
    struct timer_list link_up_timer;

/* common */
    struct sis1100_fdata* fdatalist[sis1100_MINORUTMASK+1];
    struct list_head fdata_list_head;
    u_int32_t local_ident, remote_ident;
    volatile enum sis1100_hw_type remote_hw, old_remote_hw;
    volatile u_int32_t doorbell;
    volatile u_int32_t lemo_status;
    volatile u_int32_t mbx0;
    volatile int got_irqs;
    struct irq_vects irq_vects[8];
    u_int32_t pending_irqs, new_irqs;
    struct handlercommand handlercommand;
    loff_t ram_size;
    int dsp_present;
    int remote_endian; /* 0: little 1: big*/
    int user_wants_swap;
    volatile u_int32_t last_opt_csr; /* used by handlercomm_lemo */

#if 0
    int dma_dac; /* use 64bit dual address cycle for dma */
    int no_dma;  /* even 32bit dma not available */
#endif
};

extern struct sis1100_softc *sis1100_devdata[sis1100_MAXCARDS];

extern struct file_operations sis1100_fops;

#define SIS1100FD(file) ((struct sis1100_fdata*)(file)->private_data)
#define SIS1100SC(file) (((struct sis1100_fdata*)(file)->private_data)->sc)

#define _plxreadreg(sc, offset) readl((sc)->plxmembase+(offset))
#define _plxwritereg(sc, offset, val) writel(val, (sc)->plxmembase+(offset))
#define _plxreadbreg(sc, offset) readb((sc)->plxmembase+(offset))
#define _plxwritebreg(sc, offset, val) writeb(val, (sc)->plxmembase+(offset))

#define plxreadlocal0(sc, offset) readl((sc)->reg_base+(offset))
#define plxreadlocal0b(sc, offset) readb((sc)->reg_base+(offset))
#define plxwritelocal0(sc, offset, val) writel(val, (sc)->reg_base+(offset))
#define plxwritelocal0b(sc, offset, val) writeb(val, (sc)->reg_base+(offset))
#define plxrawreadlocal0(sc, offset) __raw_readl((sc)->reg_base+(offset))
#define plxrawwritelocal0(sc, offset, val) __raw_writel(val, (sc)->reg_base+(offset))

#define rmb_plx() rmb()
#define rmb_reg() rmb()
#define wmb_plx() wmb()
#define wmb_reg() wmb()
#define mb_plx() mb()
#define mb_reg() mb()

int  sis1100_open(struct inode *inode, struct file *file);
int  sis1100_release(struct inode *inode, struct file *file);
int  sis1100_ioctl(struct inode *inode, struct file *file,
    	    	unsigned int cmd, unsigned long arg);
loff_t sis1100_llseek(struct file* file, loff_t offset, int orig);
int  sis1100_mmap(struct file * file, struct vm_area_struct * vma);
ssize_t sis1100_read(struct file* file, char* buf, size_t count,
    	    	loff_t* ppos);
ssize_t sis1100_write(struct file* file, const char* buf, size_t count,
    	    	loff_t* ppos);
unsigned int sis1100_poll(struct file* file,
                struct poll_table_struct* poll_table);

int sis1100_irq_thread(void* data);
void sis1100_link_up_handler(unsigned long data);

irqreturn_t sis1100_intr(int irq, void *vsc, struct pt_regs *regs);
int  sis1100_init(struct sis1100_softc* sc);
void sis1100_done(struct sis1100_softc* sc);

#endif
