#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <sys/ioctl.h>

#include "dev/pci/sis1100_var.h"
#include "sis3100_vme_calls.h"
#include "sharc_utils.h"


#define FPGA_DUALPORT_RAM_ADDR      0x40000000          /* size = 256 Lwords */ 
#define FPGA_DUALPORT_RAM_LWSIZE    0x100               /* size = 256 Lwords */ 


#define DPM_PARAMETER_CMD		FPGA_DUALPORT_RAM_ADDR		 /* use for ACK ; 0x40000000 for BUSY; 0x8eee eeee for Error */
#define DPM_PARAMETER1			FPGA_DUALPORT_RAM_ADDR + 0x4 	 /* use as SDRAM address pointer                             */
#define DPM_PARAMETER2			FPGA_DUALPORT_RAM_ADDR + 0x8 	 /* use as VME address pointer                               */
#define DPM_PARAMETER3			FPGA_DUALPORT_RAM_ADDR + 0xC 	 /* use as length (number of lwords)                         */
#define DPM_PARAMETER4			FPGA_DUALPORT_RAM_ADDR + 0x10 	 /* use as max. number of loops                              */
#define DPM_PARAMETER5			FPGA_DUALPORT_RAM_ADDR + 0x14 	 /* use as loop_counter                                      */

#define DPM_PARAMETER6			FPGA_DUALPORT_RAM_ADDR + 0x18 	 /* use in case of error for VME Status                      */
#define DPM_PARAMETER7			FPGA_DUALPORT_RAM_ADDR + 0x1C 	 /* use in case of error for written word information        */
#define DPM_PARAMETER8			FPGA_DUALPORT_RAM_ADDR + 0x20	 /* use in case of error for read word information           */
#define DPM_PARAMETER9			FPGA_DUALPORT_RAM_ADDR + 0x24	 /* use in case of error for address information             */



#define VME_CMD_WRITE1 			0x1001 		   /* read from SDRAM and write it to VME */
#define VME_CMD_WRITE2			0x1002 		   /* read from SDRAM and write it to VME */
#define VME_CMD_READ1_D32		0x1101 		   /* read (D32) from VME and write it to SDRAM */
#define VME_CMD_READ2_D32		0x1102 		   /* read (D32) from VME and write it to SDRAM */
#define VME_CMD_READ1_BLT32		0x1103 		   /* read (BLT32) from VME and write it to SDRAM */
#define VME_CMD_READ2_BLT32		0x1104		   /* read (BLT32) from VME and write it to SDRAM */
#define VME_CMD_WR_RD_TEST		0x1200


#define VME_CMD_READY			0x20000000
#define VME_CMD_BUSY			0x40000000
#define VME_CMD_FINISHED		0x80000000
#define VME_CMD_WRONG_PARAMETER		0x8eee0001
#define VME_CMD_VME_STAT_ERROR		0x8eee0012
#define VME_CMD_VME_WORDCOUNT_ERROR	0x8eee0013
#define VME_CMD_ERROR			0x8eeeeeee



/*===========================================================================*/
/* Globals					  			     */
/*===========================================================================*/

#define MAX_NUMBER_OF_PRINTS 0x01      
#define MAX_NUMBER_LWORDS 0x400000       /* 16MByte */

u_int32_t wblt_data[MAX_NUMBER_LWORDS] ;
u_int32_t rblt_data[MAX_NUMBER_LWORDS] ;

u_int32_t test1_data[16] ;




/*===========================================================================*/
/* Prototypes					  			     */
/*===========================================================================*/


int vme_ram_test_with_sharc(int ip, int ip_sharc,int ip_sdram, u_int32_t vme_start_addr, u_int32_t no_of_lwords,
                            int sharc_wr_cmd, int sharc_rd_cmd) ;

/****************************************************************************/
int main(int argc, char* argv[])
{

char* dsploader_path[60];


int p;
int p_sharc;
int p_sdram;

u_int32_t vme_addr ;
u_int32_t vme_no_of_lwords ;

u_int32_t addr ;
u_int32_t no_of_lwords ;

int loop_cnt ;
int no_loops ;
int return_code ;

/*
int offset ;
u_int32_t data ;

FILE *loaderfile;

unsigned int tempword[0x10000];
int retcode=1;

int error_cnt ;



int count=0 ;
int loadcount=0; 
int currentaddress ;
*/
int i;


if (argc<3)
  {
   printf("usage:  VME_START_ADDRESS  NO_OF_LWORDS  [NO_OF_LOOPS] \n");
  return -1;
  }

vme_addr         = strtoul(argv[1],NULL,0);
vme_no_of_lwords = strtoul(argv[2],NULL,0) ;


no_loops = 0x1 ;
if (argc>3)
  {
    no_loops = strtoul(argv[3],NULL,0) ;
  }
      printf(" no_loops  = 0x%08x \n ", no_loops );


test1_data[0]   =   0x12345678 ;
test1_data[1]   =   0x87654321 ;
test1_data[2]   =   0x11224488 ;
test1_data[3]   =   0x88442211 ;
test1_data[4]   =   0xAA559966 ;
test1_data[5]   =   0x66AA5599 ;
test1_data[6]   =   0x9966AA55 ;
test1_data[7]   =   0x559966AA ;
test1_data[8]   =   0xffffffff ;
test1_data[9]   =   0x00000000 ;
test1_data[10]  =   0xFF00FF00 ;
test1_data[11]  =   0x00FF00FF ;
test1_data[12]  =   0xFFFF0000 ;
test1_data[13]  =   0x0000FFFF ;
test1_data[14]  =   0xF0F0F0F0 ;
test1_data[15]  =   0x0F0F0F0F ;


/* open VME */
   if ((p=open("/tmp/sis1100", O_RDWR, 0))<0) {
     printf("error on opening VME environment\n");
     return -1;
   }
/* open SHARC */
   if ((p_sharc=open("/tmp/sis3100sharc", O_RDWR, 0))<0) {
     printf("error on sharc open");
     return -1;
   }

/* open SHARC */
   if ((p_sdram=open("/tmp/sis3100sdram", O_RDWR, 0))<0) {
     printf("error on sdram open");
     return -1;
   }





/**************************************************************************/
/*                                                                        */
/* Test FPGA internal Dual Ported RAM                                     */
/*  - write from SHARC an increment pattern                               */
/*  - read from PCI and check increment pattern                           */
/*                                                                        */
/**************************************************************************/

/* initialize internal FPGA Dual Ported Ram */
    for (i=0;i<FPGA_DUALPORT_RAM_LWSIZE;i++)    { wblt_data[i] = 0 ;  }

    /* write data */
    no_of_lwords = FPGA_DUALPORT_RAM_LWSIZE ;
    addr =  FPGA_DUALPORT_RAM_ADDR ;                     
    return_code = s3100_sharc_write(p_sharc, addr, wblt_data, no_of_lwords) ;
        printf("s3100_sharc_write:  return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
    if (return_code != (no_of_lwords*4)) {
        printf("s3100_sharc_write:  return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
        return -1 ;
      }


/* load and start SHARC */
  /* open SHARC loader file */
  /*   *dsploader_path =  argv[3] */ ; 
   *dsploader_path = "LoaderFiles/vmram_t1.ldr" ;  

   if ((load_dsp(p,p_sharc, *dsploader_path)) != 0) {
     printf("error on loading DSP code\n");
     return -1;
   }


/* wait for ready in DPM_PARAMETER_CMD */


    /* read data */
    addr =  DPM_PARAMETER_CMD ;                     
    no_of_lwords = 0x1 ;
    do {
        return_code = s3100_sharc_read(p_sharc, addr, rblt_data, no_of_lwords) ;
        if (return_code != (no_of_lwords*4)) {
           printf("s3100_sharc_read:  return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
           return -1 ;
        }
     } while ( rblt_data[0] != VME_CMD_READY ) ;

      printf("s3100_sharc_read after loading:  SHARC Reply = 0x%08x \n",rblt_data[0]  );         

   loop_cnt = 0x0 ;
    do {

     /* Test   VME_CMD_WRITE1, VME_CMD_READ1_D32 */
       return_code = vme_ram_test_with_sharc(p, p_sharc, p_sdram, vme_addr, vme_no_of_lwords, VME_CMD_WRITE1, VME_CMD_READ1_D32) ;
       if (return_code != 0)  {
          printf("Error in vme_ram_test_with_sharc:  vme_addr = 0x%08x   vme_no_of_lwords = 0x%08x  VME_CMD_WRITE1, VME_CMD_READ1_D32 \n", vme_addr, vme_no_of_lwords );         
          return -1 ;
         }
       printf("Test SHARC_VME_RAM_TEST (VME_CMD_WRITE1, VME_CMD_READ1_D32) from PCI    OK\n");         

     /* Test   VME_CMD_WRITE2, VME_CMD_READ1_D32 */
       return_code = vme_ram_test_with_sharc(p, p_sharc, p_sdram, vme_addr, vme_no_of_lwords, VME_CMD_WRITE2, VME_CMD_READ1_D32) ;
       if (return_code != 0)  {
          printf("Error in vme_ram_test_with_sharc:  vme_addr = 0x%08x   vme_no_of_lwords = 0x%08x  VME_CMD_WRITE2, VME_CMD_READ1_D32 \n", vme_addr, vme_no_of_lwords );         
          return -1 ;
         }
       printf("Test SHARC_VME_RAM_TEST (VME_CMD_WRITE2, VME_CMD_READ1_D32) from PCI    OK\n");         


     /* Test   VME_CMD_WRITE2, VME_CMD_READ2_D32 */
       return_code = vme_ram_test_with_sharc(p, p_sharc, p_sdram, vme_addr, vme_no_of_lwords, VME_CMD_WRITE2, VME_CMD_READ2_D32) ;
       if (return_code != 0)  {
          printf("Error in vme_ram_test_with_sharc:  vme_addr = 0x%08x   vme_no_of_lwords = 0x%08x  VME_CMD_WRITE2, VME_CMD_READ2_D32 \n", vme_addr, vme_no_of_lwords );         
          return -1 ;
         }
       printf("Test SHARC_VME_RAM_TEST (VME_CMD_WRITE2, VME_CMD_READ2_D32) from PCI    OK\n");         


    /* Test   VME_CMD_WRITE2, VME_CMD_READ1_BLT32  */
       return_code = vme_ram_test_with_sharc(p, p_sharc, p_sdram, vme_addr, vme_no_of_lwords, VME_CMD_WRITE2, VME_CMD_READ1_BLT32) ;
       if (return_code != 0)  {
          printf("Error in vme_ram_test_with_sharc:  vme_addr = 0x%08x   vme_no_of_lwords = 0x%08x  VME_CMD_WRITE2, VME_CMD_READ1_BLT32   \n", vme_addr, vme_no_of_lwords );         
          return -1 ;
         }
       printf("Test SHARC_VME_RAM_TEST (VME_CMD_WRITE2, VME_CMD_READ1_BLT32) from PCI    OK\n");         



     /* Test   VME_CMD_WRITE2, VME_CMD_READ2_BLT32  */
        return_code = vme_ram_test_with_sharc(p, p_sharc, p_sdram, vme_addr, vme_no_of_lwords, VME_CMD_WRITE2, VME_CMD_READ2_BLT32) ;
        if (return_code != 0)  {
          printf("Error in vme_ram_test_with_sharc:  vme_addr = 0x%08x   vme_no_of_lwords = 0x%08x  VME_CMD_WRITE2, VME_CMD_READ2_BLT32   \n", vme_addr, vme_no_of_lwords );         
          return -1 ;
         }
       printf("Test SHARC_VME_RAM_TEST (VME_CMD_WRITE2, VME_CMD_READ2_BLT32) from PCI    OK\n");         


      loop_cnt = loop_cnt + 1 ;

      if ((loop_cnt & 0xFF) == 0x0 )
      {
        printf(" loop counter = 0x%08x \n ", loop_cnt);
       }
    } while ((return_code >= 0) && (loop_cnt != no_loops)) ;

    printf("Test VME_MEMORY_TEST from SHARC    OK\n");         

 





close(p);
close(p_sharc);
close(p_sdram);

return 0 ;
}


















/*********************************************************/

/* the sharc program vmram_t1.ldr has to be loaded !!!!  */

int vme_ram_test_with_sharc(int ip, int ip_sharc,int ip_sdram, u_int32_t vme_start_addr, u_int32_t no_of_lwords,
                            int sharc_wr_cmd, int sharc_rd_cmd)
{


/*
#define MAX_NUMBER_OF_PRINTS 0x10      
#define MAX_NUMBER_LWORDS 0x400000        
u_int32_t wblt_data[MAX_NUMBER_LWORDS] ;
u_int32_t rblt_data[MAX_NUMBER_LWORDS] ;
int get_lwords ;
u_int32_t iaddr ;

*/

u_int32_t wblt_cmd_data[0x10] ;


#define PCI_SDRAM_WR_ADDR 0x0000000  /* first 16MByte */      
#define PCI_SDRAM_RD_ADDR 0x1000000  /* second 16MByte */      

#define SHARC_SDRAM_WR_ADDR 0x0000000  /* first 16MByte */      
#define SHARC_SDRAM_RD_ADDR 0x400000   /* second 16MByte */      


u_int32_t sdram_start_rd_addr ;
u_int32_t sdram_start_wr_addr ;


u_int32_t addr ;


int i;
int error_cnt ;
int return_code ;



if (no_of_lwords > MAX_NUMBER_LWORDS)  {
     printf("no_of_lwords (0x%08x) must be lower then MAX_NUMBER_LWORDS (0x%08x)\n",no_of_lwords, MAX_NUMBER_LWORDS);
     return -1;
   }

if (no_of_lwords == 0)  {
     printf("no_of_lwords (0x%08x) must be higher then 1 \n",no_of_lwords);
     return -1;
   }



/******************************************************************/
/*                                                                */
/* step 1:   write increment pattern                              */
/*                                                                */
/******************************************************************/


    /* prepare data */
    for (i=0;i<no_of_lwords;i++)    { wblt_data[i] = i ;  }

    /* write data to SDRAM  */
    sdram_start_wr_addr =  PCI_SDRAM_WR_ADDR ;
    return_code = s3100_sdram_write(ip_sdram, sdram_start_wr_addr, wblt_data, no_of_lwords) ;
    if (return_code != (no_of_lwords*4)) {
        printf("s3100_sdram_write:  return_code = 0x%08x  at address = 0x%08x\n", return_code, sdram_start_wr_addr );         
        return -1 ;
      }





/* prepare parameter for DSP write command */
    addr = DPM_PARAMETER_CMD ;                /*                            */                 
    wblt_cmd_data[0] =   0x0                    ; /* clear command              */ 
    wblt_cmd_data[1] =   SHARC_SDRAM_WR_ADDR    ; /* use as SDRAM address       */ 
    wblt_cmd_data[2] =   vme_start_addr         ; /* use as VME address         */
    wblt_cmd_data[3] =   no_of_lwords           ; /* use as length (number of lwords)  */

    return_code = s3100_sharc_write(ip_sharc, addr, wblt_cmd_data, 0x4) ; /* write 4 Lwords */
    if (return_code != (0x4*4)) {
        printf("s3100_sharc_write:  return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
        return -1 ;
      }

/* DSP write command */
    addr = DPM_PARAMETER_CMD ;                   
    wblt_cmd_data[0] =   sharc_wr_cmd   ; /*       */ 
    return_code = s3100_sharc_write(ip_sharc, addr, wblt_cmd_data, 0x1) ; /* write 1 Lwords */
    if (return_code != (4)) {
        printf("s3100_sharc_write:  return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
        return -1 ;
      }

/* wait for CMD Ready */
  do {
      addr = DPM_PARAMETER_CMD ;                   
      return_code = s3100_sharc_read(ip_sharc, addr, rblt_data, 0x1 /*no_of_lwords*/) ;
     } while (((rblt_data[0] & 0x40000000) == 0x40000000) && (return_code == 0x4)); /* while BUSY and Return OK */
   
    if (return_code != (4)) {
        printf("s3100_sharc_read1:  return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
        return -1 ;
      }
/*    if ((rblt_data[0] & 0x80000000) != 0x80000000) { */
    if ((rblt_data[0] ) != 0x80000000) {
        printf("  \n");         
        printf("Error Sharc CMD Reply:  SHARC Command Reply = 0x%08x \n",rblt_data[0] );         
        if (rblt_data[0] == VME_CMD_VME_STAT_ERROR)      printf("VME STATUS ERROR  (Arbitration Timeout or Buserror) \n");   
        if (rblt_data[0] == VME_CMD_VME_WORDCOUNT_ERROR) printf("VME DMA WORDCOUNT ERROR \n");   
        printf("  \n");         
        return -1 ;
      }


#ifdef vme_check

    iaddr =  vme_start_addr ;                     
           return_code =   vme_A32BLT32_read(ip, iaddr, rblt_data, no_of_lwords, &get_lwords) ;
           if(return_code != 0) {
              printf("return Error vme_A32BLT32_read:   return_code = 0x%08x  at address = 0x%08x\n", return_code, iaddr );         
              return -1 ; 
             }
           if(no_of_lwords != get_lwords) {
              printf("length Error vme_A32BLT32_read:   must length = 0x%08x  read length = 0x%08x\n", no_of_lwords, get_lwords );         
              return -1 ; 
             }

 
	   for (i=0x50; i<0x55; i++)  {
                 printf("VME values before SHARC Read     i = %d  data = 0x%08x\n", i, rblt_data[i] );         

           } /* for */

#endif
    



/* prepare parameter for DSP read command */
    addr = DPM_PARAMETER_CMD ;                /*                            */                 
    wblt_cmd_data[0] =   0x0                    ; /* clear command              */ 
    wblt_cmd_data[1] =   SHARC_SDRAM_RD_ADDR    ; /* use as SDRAM address       */ 
    wblt_cmd_data[2] =   vme_start_addr         ; /* use as VME address         */
    wblt_cmd_data[3] =   no_of_lwords           ; /* use as length (number of lwords)  */

    return_code = s3100_sharc_write(ip_sharc, addr, wblt_cmd_data, 0x4) ; /* write 4 Lwords */
    if (return_code != (0x4*4)) {
        printf("s3100_sharc_write:  return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
        return -1 ;
      }

/* DSP read command */
    addr = DPM_PARAMETER_CMD ;                   
    wblt_cmd_data[0] =   sharc_rd_cmd   ; /*       */ 

    return_code = s3100_sharc_write(ip_sharc, addr, wblt_cmd_data, 0x1) ; /* write 1 Lwords */
    if (return_code != (4)) {
        printf("s3100_sharc_write:  return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
        return -1 ;
      }

/* wait for CMD Ready */
  do {
      addr = DPM_PARAMETER_CMD ;                   
      return_code = s3100_sharc_read(ip_sharc, addr, rblt_data, 0x1 /*no_of_lwords*/) ;
       /*         printf("SHARC Command Reply = 0x%08x \n",rblt_data[0] );  */       

    } while (((rblt_data[0] & 0x40000000) == 0x40000000) && (return_code == 0x4)); /* while BUSY and Return OK */
   
    if (return_code != (4)) {
        printf("s3100_sharc_read2:  return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
        return -1 ;
      }
 
    if ((rblt_data[0] ) != 0x80000000) {
        printf("  \n");         
        printf("Error Sharc CMD Reply:  SHARC Command Reply = 0x%08x \n",rblt_data[0] );         
        if (rblt_data[0] == VME_CMD_VME_STAT_ERROR)      printf("VME STATUS ERROR  (Arbitration Timeout or Buserror) \n");   
        if (rblt_data[0] == VME_CMD_VME_WORDCOUNT_ERROR) printf("VME DMA WORDCOUNT ERROR \n");   
        printf("  \n");         
        return -1 ;
      }





#ifdef vme_check
    iaddr =  vme_start_addr ;                     
           return_code =   vme_A32BLT32_read(ip, iaddr, rblt_data, no_of_lwords, &get_lwords) ;
           if(return_code != 0) {
              printf("return Error vme_A32BLT32_read:   return_code = 0x%08x  at address = 0x%08x\n", return_code, iaddr );         
              return -1 ; 
             }
           if(no_of_lwords != get_lwords) {
              printf("length Error vme_A32BLT32_read:   must length = 0x%08x  read length = 0x%08x\n", no_of_lwords, get_lwords );         
              return -1 ; 
             }

 
	   for (i=0x50; i<0x55; i++)  {
                 printf("VME values after SHARC Read     i = %d  data = 0x%08x\n", i, rblt_data[i] );         

           } /* for */

#endif

    /* read data from SDRAM */
    sdram_start_rd_addr =  PCI_SDRAM_RD_ADDR ;
    return_code = s3100_sdram_read(ip_sdram, sdram_start_rd_addr, rblt_data, no_of_lwords) ;
    if (return_code != (no_of_lwords*4))   {
        printf("s3100_sdram_read3:  return_code = 0x%08x  at address = 0x%08x\n", return_code, sdram_start_rd_addr );         
        return -1 ;
      }

     /* check data */
     error_cnt =  0 ;
     for (i=0;(i)<no_of_lwords;i++)
       {
          if (wblt_data[i] != rblt_data[i])  
           {
             printf(" Error at i = : 0x%08x    written = : 0x%08x   read = : 0x%08x\n", i, wblt_data[i], rblt_data[i]);
             error_cnt = error_cnt + 1;
             if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
           }
       }


/******************************************************************/
/*                                                                */
/* step 2:   bit shift pattern                                    */
/*                                                                */
/******************************************************************/
    /* prepare data */
    for (i=0;i<no_of_lwords;i++)    { wblt_data[i] = (0x1 << (i&0x1f)) ;  }
/*   for (i=0;i<no_of_lwords;i++)    { printf("w = 0x%08x \n", wblt_data[i]);  } */


    /* write data to SDRAM  */
    sdram_start_wr_addr =  PCI_SDRAM_WR_ADDR ;
    return_code = s3100_sdram_write(ip_sdram, sdram_start_wr_addr, wblt_data, no_of_lwords) ;
    if (return_code != (no_of_lwords*4)) {
        printf("s3100_sdram_write:  return_code = 0x%08x  at address = 0x%08x\n", return_code, sdram_start_wr_addr );         
        return -1 ;
      }





/* prepare parameter for DSP write command */
    addr = DPM_PARAMETER_CMD ;                /*                            */                 
    wblt_cmd_data[0] =   0x0                    ; /* clear command              */ 
    wblt_cmd_data[1] =   SHARC_SDRAM_WR_ADDR    ; /* use as SDRAM address       */ 
    wblt_cmd_data[2] =   vme_start_addr         ; /* use as VME address         */
    wblt_cmd_data[3] =   no_of_lwords           ; /* use as length (number of lwords)  */

    return_code = s3100_sharc_write(ip_sharc, addr, wblt_cmd_data, 0x4) ; /* write 4 Lwords */
    if (return_code != (0x4*4)) {
        printf("s3100_sharc_write:  return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
        return -1 ;
      }

/* DSP write command */
    addr = DPM_PARAMETER_CMD ;                   
    wblt_cmd_data[0] =   sharc_wr_cmd   ; /*       */ 
    return_code = s3100_sharc_write(ip_sharc, addr, wblt_cmd_data, 0x1) ; /* write 1 Lwords */
    if (return_code != (4)) {
        printf("s3100_sharc_write:  return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
        return -1 ;
      }

/* wait for CMD Ready */
  do {
      addr = DPM_PARAMETER_CMD ;                   
      return_code = s3100_sharc_read(ip_sharc, addr, rblt_data, 0x1 /*no_of_lwords*/) ;
     } while (((rblt_data[0] & 0x40000000) == 0x40000000) && (return_code == 0x4)); /* while BUSY and Return OK */
   
    if (return_code != (4)) {
        printf("s3100_sharc_read:  return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
        return -1 ;
      }

    if ((rblt_data[0] ) != 0x80000000) {
        printf("  \n");         
        printf("Error Sharc CMD Reply:  SHARC Command Reply = 0x%08x \n",rblt_data[0] );         
        if (rblt_data[0] == VME_CMD_VME_STAT_ERROR)      printf("VME STATUS ERROR  (Arbitration Timeout or Buserror) \n");   
        if (rblt_data[0] == VME_CMD_VME_WORDCOUNT_ERROR) printf("VME DMA WORDCOUNT ERROR \n");   
        printf("  \n");         
        return -1 ;
      }





/* prepare parameter for DSP read command */
    addr = DPM_PARAMETER_CMD ;                /*                            */                 
    wblt_cmd_data[0] =   0x0                    ; /* clear command              */ 
    wblt_cmd_data[1] =   SHARC_SDRAM_RD_ADDR    ; /* use as SDRAM address       */ 
    wblt_cmd_data[2] =   vme_start_addr         ; /* use as VME address         */
    wblt_cmd_data[3] =   no_of_lwords           ; /* use as length (number of lwords)  */

    return_code = s3100_sharc_write(ip_sharc, addr, wblt_cmd_data, 0x4) ; /* write 4 Lwords */
    if (return_code != (0x4*4)) {
        printf("s3100_sharc_write:  return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
        return -1 ;
      }

/* DSP read command */
    addr = DPM_PARAMETER_CMD ;                   
    wblt_cmd_data[0] =   sharc_rd_cmd   ; /*       */ 
    return_code = s3100_sharc_write(ip_sharc, addr, wblt_cmd_data, 0x1) ; /* write 1 Lwords */
    if (return_code != (4)) {
        printf("s3100_sharc_write:  return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
        return -1 ;
      }

/* wait for CMD Ready */
  do {
      addr = DPM_PARAMETER_CMD ;                   
      return_code = s3100_sharc_read(ip_sharc, addr, rblt_data, 0x1 /*no_of_lwords*/) ;
     } while (((rblt_data[0] & 0x40000000) == 0x40000000) && (return_code == 0x4)); /* while BUSY and Return OK */
   
    if (return_code != (4)) {
        printf("s3100_sharc_read:  return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
        return -1 ;
      }

    if ((rblt_data[0] ) != 0x80000000) {
        printf("  \n");         
        printf("Error Sharc CMD Reply:  SHARC Command Reply = 0x%08x \n",rblt_data[0] );         
        if (rblt_data[0] == VME_CMD_VME_STAT_ERROR)      printf("VME STATUS ERROR  (Arbitration Timeout or Buserror) \n");   
        if (rblt_data[0] == VME_CMD_VME_WORDCOUNT_ERROR) printf("VME DMA WORDCOUNT ERROR \n");   
        printf("  \n");         
        return -1 ;
      }





    /* read data from SDRAM */
    sdram_start_rd_addr =  PCI_SDRAM_RD_ADDR ;
    return_code = s3100_sdram_read(ip_sdram, sdram_start_rd_addr, rblt_data, no_of_lwords) ;
    if (return_code != (no_of_lwords*4))   {
        printf("s3100_sdram_read:  return_code = 0x%08x  at address = 0x%08x\n", return_code, sdram_start_rd_addr );         
        return -1 ;
      }







     /* check data */
     error_cnt =  0 ;
     for (i=0;(i)<no_of_lwords;i++)
       {
          if (wblt_data[i] != rblt_data[i])  
           {
             printf(" Error at i = : 0x%08x    written = : 0x%08x   read = : 0x%08x\n", i, wblt_data[i], rblt_data[i]);
             error_cnt = error_cnt + 1;
             if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
           }
       }


/******************************************************************/
/*                                                                */
/* step 3:    pattern                                             */
/*                                                                */
/******************************************************************/
    /* prepare data */
    for (i=0;i<no_of_lwords;i++)    { wblt_data[i] =  test1_data[i&0xf] ;  }
/*    for (i=0;i<no_of_lwords;i++)    { printf("w = 0x%08x \n", wblt_data[i]);  }  */



    /* write data to SDRAM  */
    sdram_start_wr_addr =  PCI_SDRAM_WR_ADDR ;
    return_code = s3100_sdram_write(ip_sdram, sdram_start_wr_addr, wblt_data, no_of_lwords) ;
    if (return_code != (no_of_lwords*4)) {
        printf("s3100_sdram_write:  return_code = 0x%08x  at address = 0x%08x\n", return_code, sdram_start_wr_addr );         
        return -1 ;
      }





/* prepare parameter for DSP write command */
    addr = DPM_PARAMETER_CMD ;                /*                            */                 
    wblt_cmd_data[0] =   0x0                    ; /* clear command              */ 
    wblt_cmd_data[1] =   SHARC_SDRAM_WR_ADDR    ; /* use as SDRAM address       */ 
    wblt_cmd_data[2] =   vme_start_addr         ; /* use as VME address         */
    wblt_cmd_data[3] =   no_of_lwords           ; /* use as length (number of lwords)  */

    return_code = s3100_sharc_write(ip_sharc, addr, wblt_cmd_data, 0x4) ; /* write 4 Lwords */
    if (return_code != (0x4*4)) {
        printf("s3100_sharc_write:  return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
        return -1 ;
      }

/* DSP write command */
    addr = DPM_PARAMETER_CMD ;                   
    wblt_cmd_data[0] =   sharc_wr_cmd   ; /*       */ 
    return_code = s3100_sharc_write(ip_sharc, addr, wblt_cmd_data, 0x1) ; /* write 1 Lwords */
    if (return_code != (4)) {
        printf("s3100_sharc_write:  return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
        return -1 ;
      }

/* wait for CMD Ready */
  do {
      addr = DPM_PARAMETER_CMD ;                   
      return_code = s3100_sharc_read(ip_sharc, addr, rblt_data, 0x1 /*no_of_lwords*/) ;
     } while (((rblt_data[0] & 0x40000000) == 0x40000000) && (return_code == 0x4)); /* while BUSY and Return OK */
   
    if (return_code != (4)) {
        printf("s3100_sharc_read:  return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
        return -1 ;
      }

    if ((rblt_data[0] ) != 0x80000000) {
        printf("  \n");         
        printf("Error Sharc CMD Reply:  SHARC Command Reply = 0x%08x \n",rblt_data[0] );         
        if (rblt_data[0] == VME_CMD_VME_STAT_ERROR)      printf("VME STATUS ERROR  (Arbitration Timeout or Buserror) \n");   
        if (rblt_data[0] == VME_CMD_VME_WORDCOUNT_ERROR) printf("VME DMA WORDCOUNT ERROR \n");   
        printf("  \n");         
        return -1 ;
      }




/* prepare parameter for DSP read command */
    addr = DPM_PARAMETER_CMD ;                /*                            */                 
    wblt_cmd_data[0] =   0x0                    ; /* clear command              */ 
    wblt_cmd_data[1] =   SHARC_SDRAM_RD_ADDR    ; /* use as SDRAM address       */ 
    wblt_cmd_data[2] =   vme_start_addr         ; /* use as VME address         */
    wblt_cmd_data[3] =   no_of_lwords           ; /* use as length (number of lwords)  */

    return_code = s3100_sharc_write(ip_sharc, addr, wblt_cmd_data, 0x4) ; /* write 4 Lwords */
    if (return_code != (0x4*4)) {
        printf("s3100_sharc_write:  return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
        return -1 ;
      }

/* DSP read command */
    addr = DPM_PARAMETER_CMD ;                   
    wblt_cmd_data[0] =   sharc_rd_cmd   ; /*       */ 
    return_code = s3100_sharc_write(ip_sharc, addr, wblt_cmd_data, 0x1) ; /* write 1 Lwords */
    if (return_code != (4)) {
        printf("s3100_sharc_write:  return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
        return -1 ;
      }

/* wait for CMD Ready */
  do {
      addr = DPM_PARAMETER_CMD ;                   
      return_code = s3100_sharc_read(ip_sharc, addr, rblt_data, 0x1 /*no_of_lwords*/) ;
     } while (((rblt_data[0] & 0x40000000) == 0x40000000) && (return_code == 0x4)); /* while BUSY and Return OK */
   
    if (return_code != (4)) {
        printf("s3100_sharc_read:  return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
        return -1 ;
      }

    if ((rblt_data[0] ) != 0x80000000) {
        printf("  \n");         
        printf("Error Sharc CMD Reply:  SHARC Command Reply = 0x%08x \n",rblt_data[0] );         
        if (rblt_data[0] == VME_CMD_VME_STAT_ERROR)      printf("VME STATUS ERROR  (Arbitration Timeout or Buserror) \n");   
        if (rblt_data[0] == VME_CMD_VME_WORDCOUNT_ERROR) printf("VME DMA WORDCOUNT ERROR \n");   
        printf("  \n");         
        return -1 ;
      }


 





    /* read data from SDRAM */
    sdram_start_rd_addr =  PCI_SDRAM_RD_ADDR ;
    return_code = s3100_sdram_read(ip_sdram, sdram_start_rd_addr, rblt_data, no_of_lwords) ;
    if (return_code != (no_of_lwords*4))   {
        printf("s3100_sdram_read:  return_code = 0x%08x  at address = 0x%08x\n", return_code, sdram_start_rd_addr );         
        return -1 ;
      }







     /* check data */
     error_cnt =  0 ;
     for (i=0;(i)<no_of_lwords;i++)
       {
          if (wblt_data[i] != rblt_data[i])  
           {
             printf(" Error at i = : 0x%08x    written = : 0x%08x   read = : 0x%08x\n", i, wblt_data[i], rblt_data[i]);
             error_cnt = error_cnt + 1;
             if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
           }
       }




/******************************************************************/
/*                                                                */
/* step 4:    random                                              */
/*                                                                */
/******************************************************************/
    /* prepare data */
    for (i=0;i<no_of_lwords;i++)    { wblt_data[i] =  random() ;  }
/*    for (i=0;i<no_of_lwords;i++)    { printf("w = 0x%08x \n", wblt_data[i]);  }   */



    /* write data to SDRAM  */
    sdram_start_wr_addr =  PCI_SDRAM_WR_ADDR ;
    return_code = s3100_sdram_write(ip_sdram, sdram_start_wr_addr, wblt_data, no_of_lwords) ;
    if (return_code != (no_of_lwords*4)) {
        printf("s3100_sdram_write:  return_code = 0x%08x  at address = 0x%08x\n", return_code, sdram_start_wr_addr );         
        return -1 ;
      }





/* prepare parameter for DSP write command */
    addr = DPM_PARAMETER_CMD ;                /*                            */                 
    wblt_cmd_data[0] =   0x0                    ; /* clear command              */ 
    wblt_cmd_data[1] =   SHARC_SDRAM_WR_ADDR    ; /* use as SDRAM address       */ 
    wblt_cmd_data[2] =   vme_start_addr         ; /* use as VME address         */
    wblt_cmd_data[3] =   no_of_lwords           ; /* use as length (number of lwords)  */

    return_code = s3100_sharc_write(ip_sharc, addr, wblt_cmd_data, 0x4) ; /* write 4 Lwords */
    if (return_code != (0x4*4)) {
        printf("s3100_sharc_write:  return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
        return -1 ;
      }

/* DSP write command */
    addr = DPM_PARAMETER_CMD ;                   
    wblt_cmd_data[0] =   sharc_wr_cmd   ; /*       */ 
    return_code = s3100_sharc_write(ip_sharc, addr, wblt_cmd_data, 0x1) ; /* write 1 Lwords */
    if (return_code != (4)) {
        printf("s3100_sharc_write:  return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
        return -1 ;
      }

/* wait for CMD Ready */
  do {
      addr = DPM_PARAMETER_CMD ;                   
      return_code = s3100_sharc_read(ip_sharc, addr, rblt_data, 0x1 /*no_of_lwords*/) ;
     } while (((rblt_data[0] & 0x40000000) == 0x40000000) && (return_code == 0x4)); /* while BUSY and Return OK */
   
    if (return_code != (4)) {
        printf("s3100_sharc_read:  return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
        return -1 ;
      }


    if ((rblt_data[0] ) != 0x80000000) {
        printf("  \n");         
        printf("Error Sharc CMD Reply:  SHARC Command Reply = 0x%08x \n",rblt_data[0] );         
        if (rblt_data[0] == VME_CMD_VME_STAT_ERROR)      printf("VME STATUS ERROR  (Arbitration Timeout or Buserror) \n");   
        if (rblt_data[0] == VME_CMD_VME_WORDCOUNT_ERROR) printf("VME DMA WORDCOUNT ERROR \n");   
        printf("  \n");         
        return -1 ;
      }





/* prepare parameter for DSP read command */
    addr = DPM_PARAMETER_CMD ;                /*                            */                 
    wblt_cmd_data[0] =   0x0                    ; /* clear command              */ 
    wblt_cmd_data[1] =   SHARC_SDRAM_RD_ADDR    ; /* use as SDRAM address       */ 
    wblt_cmd_data[2] =   vme_start_addr         ; /* use as VME address         */
    wblt_cmd_data[3] =   no_of_lwords           ; /* use as length (number of lwords)  */

    return_code = s3100_sharc_write(ip_sharc, addr, wblt_cmd_data, 0x4) ; /* write 4 Lwords */
    if (return_code != (0x4*4)) {
        printf("s3100_sharc_write:  return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
        return -1 ;
      }

/* DSP read command */
    addr = DPM_PARAMETER_CMD ;                   
    wblt_cmd_data[0] =   sharc_rd_cmd   ; /*       */ 
    return_code = s3100_sharc_write(ip_sharc, addr, wblt_cmd_data, 0x1) ; /* write 1 Lwords */
    if (return_code != (4)) {
        printf("s3100_sharc_write:  return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
        return -1 ;
      }

/* wait for CMD Ready */
  do {
      addr = DPM_PARAMETER_CMD ;                   
      return_code = s3100_sharc_read(ip_sharc, addr, rblt_data, 0x1 /*no_of_lwords*/) ;
     } while (((rblt_data[0] & 0x40000000) == 0x40000000) && (return_code == 0x4)); /* while BUSY and Return OK */
   
    if (return_code != (4)) {
        printf("s3100_sharc_read:  return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
        return -1 ;
      }

    if ((rblt_data[0] ) != 0x80000000) {
        printf("  \n");         
        printf("Error Sharc CMD Reply:  SHARC Command Reply = 0x%08x \n",rblt_data[0] );         
        if (rblt_data[0] == VME_CMD_VME_STAT_ERROR)      printf("VME STATUS ERROR  (Arbitration Timeout or Buserror) \n");   
        if (rblt_data[0] == VME_CMD_VME_WORDCOUNT_ERROR) printf("VME DMA WORDCOUNT ERROR \n");   
        printf("  \n");         
        return -1 ;
      }





    /* read data from SDRAM */
    sdram_start_rd_addr =  PCI_SDRAM_RD_ADDR ;
    return_code = s3100_sdram_read(ip_sdram, sdram_start_rd_addr, rblt_data, no_of_lwords) ;
    if (return_code != (no_of_lwords*4))   {
        printf("s3100_sdram_read:  return_code = 0x%08x  at address = 0x%08x\n", return_code, sdram_start_rd_addr );         
        return -1 ;
      }







     /* check data */
     error_cnt =  0 ;
     for (i=0;(i)<no_of_lwords;i++)
       {
          if (wblt_data[i] != rblt_data[i])  
           {
             printf(" Error at i = : 0x%08x    written = : 0x%08x   read = : 0x%08x\n", i, wblt_data[i], rblt_data[i]);
             error_cnt = error_cnt + 1;
             if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
           }
       }




  if (error_cnt == 0) {
     return 0 ; }
    else {
     return -1 ;}

}












































