#ifndef MARS_MPedestalCam
#define MARS_MPedestalCam

#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif

class TClonesArray;

class MGeomCam;
class MPedestalPix;

class MPedestalCam : public MCamEvent
{
private:
    TClonesArray *fArray; // FIXME: Change TClonesArray away from a pointer?

public:
    MPedestalCam(const char *name=NULL, const char *title=NULL);
    ~MPedestalCam();

    void Clear(Option_t *o="");

    void InitSize(const UInt_t i);
    Int_t GetSize() const;

    MPedestalPix &operator[](Int_t i);
    MPedestalPix &operator[](Int_t i) const;

    Float_t GetMeanMin(const MGeomCam *cam) const;
    Float_t GetMeanMax(const MGeomCam *cam) const;

    Bool_t CheckBounds(Int_t i);

    void Print(Option_t *o="") const;

    Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
    void DrawPixelContent(Int_t num) const
    {
    }

    ClassDef(MPedestalCam, 1)	// Storage Container for all pedestal information of the camera
};

#endif

