#ifndef MARS_MRflEvtData
#define MARS_MRflEvtData

#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif

#ifndef ROOT_TClonesArray
#include <TClonesArray.h>
#endif

class MRflSinglePhoton;

class MRflEvtData : public MCamEvent
{
    TClonesArray fList;
    Int_t fPos;

public:
    MRflEvtData(const char *name=NULL, const char *title=NULL);

    void Reset() { fPos = 0; }

    Int_t GetNumPhotons() const { return fList.GetEntriesFast(); }

    MRflSinglePhoton &GetNewPhoton();
    void FixSize();

    const MRflSinglePhoton &GetPhoton(Int_t i) const;

    void Print(Option_t *o="") const;

    Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
    void   DrawPixelContent(Int_t num) const;

    ClassDef(MRflEvtData, 0) // All Photons of a event from the reflector program
};

#endif
