#ifndef MARS_MGeomPix
#define MARS_MGeomPix

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MGeomCam;

class MGeomPix : public MParContainer
{ 
private:
    enum {
        kIsInOutermostRing = BIT(22),
        kIsInOuterRing     = BIT(23),
        kUserBits          = 0x1fc000 // 14-21 are allowed

    };

    Float_t fX;  // [mm] the x coordinate of the center
    Float_t fY;  // [mm] the y coordinate of the center
    Float_t fD;  // [mm] the d coordinate of the pixel (dist between two parallel sides)

    Byte_t  fNumNeighbors; // number of valid neighbors
    Short_t fNeighbors[6]; // the IDs of the pixel next to it (we are assuming an hexagonal geometry)

    UInt_t fSector; // Number of sector the pixels corresponds to

public:
    MGeomPix(Float_t x=0, Float_t y=0, Float_t d=0, UInt_t s=0);

    void Print(Option_t *opt=NULL) const;

    void Set(Float_t x, Float_t y, Float_t d, UInt_t s=0) { fX=x; fY=y; fD=d; fSector=s; }

    void SetNeighbors(Short_t i0=-1, Short_t i1=-1, Short_t i2=-1,
                      Short_t i3=-1, Short_t i4=-1, Short_t i5=-1);

    void CheckOuterRing(const MGeomCam &cam);
    /*
     void SetX(Float_t x) { fX = x; }
     void SetY(Float_t y) { fY = y; }
     void SetD(Float_t d) { fD = d; }
     void SetSector(UInt_t s) { fSector = s; }
     */

    Float_t GetX() const  { return fX; }
    Float_t GetY() const  { return fY; }
    Float_t GetD() const  { return fD; }
    UInt_t  GetSector() const { return fSector; }

    Float_t GetA() const;

    Byte_t  GetNumNeighbors() const { return fNumNeighbors; }
    Short_t GetNeighbor(Byte_t i) const { return fNeighbors[i]; }

    Bool_t IsInOutermostRing() const { return TestBit(kIsInOutermostRing); }
    Bool_t IsInOuterRing() const     { return TestBit(kIsInOuterRing); }

    /*
     //
     // These function are for future usage. They are not virtual in
     // root by now.
     //
     void SetBit(UInt_t f, Bool_t set) { set ? TObject::SetBit(f) : TObject::ResetBit(f); }
     void SetBit(UInt_t f)    { TObject::SetBit(f & kUserBits); }
     void ResetBit(UInt_t f)  { TObject::ResetBit(f & kUserBits); }
     void InvertBit(UInt_t f) { TObject InvertBit(f & kUserBits); }
     */

    ClassDef(MGeomPix, 1) // Geometry class describing the geometry of one pixel
};

#endif

