//
// Command-line utility to send a DIM command
//
//

#include <stdio.h>
#include <ctype.h>
#include <sys/time.h>

#include "dic.hxx"

// Get configuration data
int main(int argc, const char* argv[]) {

  struct timeval Start, End;

  if (argc != 3) {
    printf("Usage: %s <Command Name> <ASCII Data>\n", argv[0]);
    exit(EXIT_FAILURE);
  }

  // Send command
  gettimeofday(&Start, NULL);
  int Result = DimClient::sendCommand(argv[1], argv[2]);
  gettimeofday(&End, NULL);

  // Calculate time to completion
  double Diff = (End.tv_sec-Start.tv_sec)*1e6 + End.tv_usec-Start.tv_usec;

  printf("Command %s, execution time %.2f ms\n",
  	Result==1 ? "delivered" : "not delivered", Diff/1000);
}
