//
// Command-line utility to send a DIM RPC and print the result
//
//

#include <stdio.h>
#include <ctype.h>
#include <sys/time.h>

#include "dic.hxx"

#define NO_LINK (char *) "__&DIM&NOLINK&__" // Data if no link available

// Get configuration data
int main(int argc, const char* argv[]) {

  struct timeval Start, End;

  if (argc != 3) {
    printf("Usage: %s <RPC Name> <ASCII Data>\n", argv[0]);
    exit(EXIT_FAILURE);
  }

  gettimeofday(&Start, NULL);

  // Make RPC
  DimRpcInfo RPC(argv[1], NO_LINK);
  RPC.setData((char *) argv[2]);

  // Check for connection to server
  if ((RPC.getSize() == strlen(NO_LINK)+1) &&  
	  (memcmp(RPC.getData(), NO_LINK, RPC.getSize()) == 0)){
	printf("No link to server\n");
	exit(EXIT_FAILURE);  
  }

  // Calculate time to completion
  gettimeofday(&End, NULL);
  double Diff = (End.tv_sec-Start.tv_sec)*1e6 + End.tv_usec-Start.tv_usec;
  printf("Time to completion %.2f ms\nASCII\n'", Diff/1000);

  unsigned char *Result = (unsigned char *) RPC.getString();

  // Print result as text
  for (int i=0; i<RPC.getSize(); i++) {
	if (isprint(Result[i])) printf("%c", Result[i]);
	else printf(".");  
  }
  printf("'\nHex:\n");
  
  // Print result in hex 
  for (int i=0; i<RPC.getSize(); i++) {
	printf("%.2x ", Result[i]);
	if (i%4 == 3) printf(" ");
	if (i%16 == 15) printf("\n");
  }
  printf("\n");
}
