#ifndef MARS_MCerPhotAnal2
#define MARS_MCerPhotAnal2

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MCerPhotAnal2                                                            //
//                                                                         //
// Integrates the time slices of one pixel and substracts the pedestal     //
// (offset) value                                                          //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MRawEvtData;
class MPedestalCam;
class MCerPhotEvt;
class MRawRunHeader;

class MCerPhotAnal2 : public MTask
{
    MPedestalCam  *fPedestals;  // Pedestals of all pixels in the camera
    MRawEvtData   *fRawEvt;     // raw event data (time slices)
    MCerPhotEvt   *fCerPhotEvt; // Cerenkov Photon Event used for calculation
    MRawRunHeader *fRunHeader;  // RunHeader information

    Byte_t fBefore;
    Byte_t fAfter;

public:
    MCerPhotAnal2(Byte_t b=2, Byte_t a=5, const char *name=NULL, const char *title=NULL);

    Int_t PreProcess(MParList *pList);
    Int_t Process();

    ClassDef(MCerPhotAnal2, 0)   // Task to calculate cerenkov photons from raw data
};

#endif
