//
// This File contains the definition of the MGImage-class
//
//   Author: Thomas Bretz
//   Version: V1.0 (1-8-2000)
//
// x11/src/GX11Gui.cxx
//
#include "MGImage.h"

#include <iostream.h>
#include <pthread.h>

#include <X11/Xlib.h>

#include <TTimer.h>
#include <TSystem.h>
#include <TVirtualX.h>
#include <TGX11.h>

ClassImp(MGImage);
/*
class MyX11 : public TGX11
{
public:
    Display *GetDisplay() { return fDisplay; }
    Drawable GetRootWin() { return fRootWin; }
    Drawable GetVisRootWin() { return fVisRootWin; }
    Int_t    GetDepth() { return fDepth; }
};
*/

MGImage::MGImage(const TGWindow* p, UInt_t w, UInt_t h, UInt_t options, ULong_t back)
    : TGFrame(p, w, h, options, back), fWidth(w), fHeight(h)
{
    // p = pointer to MainFrame (not owner)
    // w = width of frame
    // h = width of frame

    //
    // Creat drawing semaphore
    //
    fMuxPixmap = new pthread_mutex_t;
    pthread_mutex_init((pthread_mutex_t*)fMuxPixmap, NULL);

    Resize(w, h);

    //
    // create empty pixmap
    //
    fPixmap = gVirtualX->CreatePixmap(fId, fWidth, fHeight);
    fDefGC  = gVirtualX->CreateGC(fId, 0);
    fImage  = (XImage*)gVirtualX->CreateImage(fWidth, fHeight);
}

MGImage::~MGImage()
{
    pthread_mutex_lock((pthread_mutex_t*)fMuxPixmap);

    cout << "Deleting MGImage..." << endl;

    gVirtualX->DeletePixmap(fPixmap);
    gVirtualX->DeleteGC(fDefGC);
    gVirtualX->DeleteImage((Drawable_t)fImage);

    pthread_mutex_destroy((pthread_mutex_t*)fMuxPixmap);

    cout << "MGImage destroyed." << endl;
}

void MGImage::DoRedraw()
{
    pthread_mutex_lock((pthread_mutex_t*)fMuxPixmap);

    if (TestBit(kNeedRedraw))
    {
        gVirtualX->PutImage(fId, fDefGC, (Drawable_t)fImage, 0, 0, 0, 0, fWidth, fHeight);
        ResetBit(kNeedRedraw);
    }

    pthread_mutex_unlock((pthread_mutex_t*)fMuxPixmap);
}

void MGImage::DrawImg(const byte *buffer)
{
    if (pthread_mutex_trylock((pthread_mutex_t*)fMuxPixmap))
        return;

    char *d = fImage->data;
    char *e = (char*)(buffer+fWidth*fHeight);
    char *s = (char*)buffer;

    // FIXME: This loop depends on the screen color depth
    while (s<e)
    {
        *d++ = *s;
        *d++ = *s;
        *d++ = *s++;
        d++;
    }

    SetBit(kNeedRedraw);

    pthread_mutex_unlock((pthread_mutex_t*)fMuxPixmap);
}

void MGImage::DrawColImg(const byte *gbuf, const byte *cbuf)
{
    if (pthread_mutex_trylock((pthread_mutex_t*)fMuxPixmap))
        return;

    char *d  = fImage->data;
    char *e  = (char*)(gbuf+fWidth*fHeight);
    char *s1 = (char*)gbuf;
    char *s2 = (char*)cbuf;

    // FROM libAfterImage:
    // -------------------
    //#define ALPHA_TRANSPARENT      	0x00
    //#define ALPHA_SEMI_TRANSPARENT 	0x7F
    //#define ALPHA_SOLID            	0xFF
    // * Lowermost 8 bits - Blue channel
    // * bits 8 to 15     - Green channel
    // * bits 16 to 23    - Red channel
    // * bits 24 to 31    - Alpha channel
    //#define ARGB32_White    		0xFFFFFFFF
    //#define ARGB32_Black    		0xFF000000

    // FIXME: This loop depends on the screen color depth
    while (s1<e)
    {
        if (*s2)
        {
            *d++ = ((*s2>>4)&0x3)*85;
            *d++ = ((*s2>>2)&0x3)*85;
            *d++ = ((*s2++ )&0x3)*85;
            d++;
            s1++;
        }
        else
        {
            *d++ = *s1;
            *d++ = *s1;
            *d++ = *s1++;
            d++;
            s2++;
        }
    }

    SetBit(kNeedRedraw);

    pthread_mutex_unlock((pthread_mutex_t*)fMuxPixmap);
}
