-- VHDL Entity FACT_FAD_lib.FAD_Board.symbol
--
-- Created:
--          by - dneise.UNKNOWN (TU-CC4900F8C7D2)
--          at - 11:16:26 22.06.2010
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.2 (Build 10)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

ENTITY FAD_Board IS
   PORT( 
      A0_D       : IN     std_logic_vector (11 DOWNTO 0);
      A1_D       : IN     std_logic_vector (11 DOWNTO 0);
      A2_D       : IN     std_logic_vector (11 DOWNTO 0);
      A3_D       : IN     std_logic_vector (11 DOWNTO 0);
      A_OTR      : IN     std_logic_vector (3 DOWNTO 0);
      D0_SROUT   : IN     std_logic;
      D1_SROUT   : IN     std_logic;
      D2_SROUT   : IN     std_logic;
      D3_SROUT   : IN     std_logic;
      D_PLLLCK   : IN     std_logic_vector (3 DOWNTO 0);
      TEST_TRG   : IN     std_logic;
      TRG        : IN     STD_LOGIC;
      W_INT      : IN     std_logic;
      X_50M      : IN     STD_LOGIC;
      A1_T       : OUT    std_logic_vector (3 DOWNTO 0);
      A_CLK      : OUT    std_logic_vector (3 DOWNTO 0);
      D0_SRCLK   : OUT    STD_LOGIC;
      D1_SRCLK   : OUT    STD_LOGIC;
      D2_SRCLK   : OUT    STD_LOGIC;
      D3_SRCLK   : OUT    STD_LOGIC;
      DAC_CS     : OUT    std_logic;
      DENABLE    : OUT    std_logic                       := '0';
      DWRITE     : OUT    std_logic                       := '0';
      D_A        : OUT    std_logic_vector (3 DOWNTO 0)   := (others => '0');
      D_T        : OUT    std_logic_vector (7 DOWNTO 0)   := (OTHERS => '0');
      D_T2       : OUT    std_logic_vector (3 DOWNTO 0)   := (others => '0');
      EE_CS      : OUT    std_logic;
      LED        : OUT    std_logic_vector ( 2 DOWNTO 0 ) := (others => '1');
      MOSI       : OUT    std_logic                       := '0';
      OE_ADC     : OUT    STD_LOGIC;
      RS485_C_DE : OUT    std_logic;
      RS485_C_RE : OUT    std_logic;
      RS485_E_DE : OUT    std_logic;
      RS485_E_RE : OUT    std_logic;
      RSRLOAD    : OUT    std_logic                       := '0';
      SRIN       : OUT    std_logic;
      S_CLK      : OUT    std_logic;
      T0_CS      : OUT    std_logic;
      T1_CS      : OUT    std_logic;
      T2_CS      : OUT    std_logic;
      T3_CS      : OUT    std_logic;
      TRG_V      : OUT    std_logic;
      W_A        : OUT    std_logic_vector (9 DOWNTO 0);
      W_CS       : OUT    std_logic                       := '1';
      W_RD       : OUT    std_logic                       := '1';
      W_RES      : OUT    std_logic                       := '1';
      W_WR       : OUT    std_logic                       := '1';
      MISO       : INOUT  std_logic;
      W_D        : INOUT  std_logic_vector (15 DOWNTO 0)
   );

-- Declarations

END FAD_Board ;

--
-- VHDL Architecture FACT_FAD_lib.FAD_Board.struct
--
-- Created:
--          by - dneise.UNKNOWN (TU-CC4900F8C7D2)
--          at - 11:16:26 22.06.2010
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.2 (Build 10)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE IEEE.NUMERIC_STD.all;
USE ieee.std_logic_unsigned.all;

LIBRARY FACT_FAD_lib;
USE FACT_FAD_lib.fad_definitions.all;

LIBRARY FACT_FAD_lib;

ARCHITECTURE struct OF FAD_Board IS

   -- Architecture declarations

   -- Internal signal declarations
   SIGNAL CLK_25_PS      : std_logic;
   SIGNAL CLK_50         : std_logic;
   SIGNAL SRCLK          : std_logic := '0';
   SIGNAL TRG_OR         : std_logic;
   SIGNAL adc_data_array : adc_data_array_type;
   SIGNAL board_id       : std_logic_vector(3 DOWNTO 0);
   SIGNAL crate_id       : std_logic_vector(1 DOWNTO 0);
   SIGNAL dummy          : std_logic;
   SIGNAL not_TEST_TRG   : STD_LOGIC;
   SIGNAL sensor_cs      : std_logic_vector(3 DOWNTO 0);
   SIGNAL trigger_out    : STD_LOGIC := '0';

   -- Implicit buffer signal declarations
   SIGNAL RSRLOAD_internal : std_logic;


   -- Component Declarations
   COMPONENT FAD_main
   GENERIC (
      RAMADDRWIDTH64b : integer := 12
   );
   PORT (
      CLK            : IN     std_logic ;
      SROUT_in_0     : IN     std_logic ;
      SROUT_in_1     : IN     std_logic ;
      SROUT_in_2     : IN     std_logic ;
      SROUT_in_3     : IN     std_logic ;
      adc_data_array : IN     adc_data_array_type ;
      adc_otr_array  : IN     std_logic_vector (3 DOWNTO 0);
      board_id       : IN     std_logic_vector (3 DOWNTO 0);
      crate_id       : IN     std_logic_vector (1 DOWNTO 0);
      trigger        : IN     std_logic ;
      wiz_int        : IN     std_logic ;
      CLK_25_PS      : OUT    std_logic ;
      CLK_50         : OUT    std_logic ;
      RSRLOAD        : OUT    std_logic                     := '0';
      SRCLK          : OUT    std_logic                     := '0';
      adc_oeb        : OUT    std_logic                     := '1';
      dac_cs         : OUT    std_logic ;
      denable        : OUT    std_logic                     := '0';           -- default domino wave off
      drs_channel_id : OUT    std_logic_vector (3 DOWNTO 0) := (others => '0');
      drs_dwrite     : OUT    std_logic                     := '1';
      led            : OUT    std_logic_vector (7 DOWNTO 0) := (OTHERS => '0');
      mosi           : OUT    std_logic                     := '0';
      sclk           : OUT    std_logic ;
      sensor_cs      : OUT    std_logic_vector (3 DOWNTO 0);
      wiz_addr       : OUT    std_logic_vector (9 DOWNTO 0);
      wiz_cs         : OUT    std_logic                     := '1';
      wiz_rd         : OUT    std_logic                     := '1';
      wiz_reset      : OUT    std_logic                     := '1';
      wiz_wr         : OUT    std_logic                     := '1';
      sio            : INOUT  std_logic ;
      wiz_data       : INOUT  std_logic_vector (15 DOWNTO 0)
   );
   END COMPONENT;
   COMPONENT debouncer
   GENERIC (
      WIDTH : INTEGER := 17
   );
   PORT (
      clk         : IN     STD_LOGIC ;
      --           rst : in  STD_LOGIC;
      trigger_in  : IN     STD_LOGIC ;
      trigger_out : OUT    STD_LOGIC  := '0'
   );
   END COMPONENT;

   -- Optional embedded configurations
   -- pragma synthesis_off
   FOR ALL : FAD_main USE ENTITY FACT_FAD_lib.FAD_main;
   FOR ALL : debouncer USE ENTITY FACT_FAD_lib.debouncer;
   -- pragma synthesis_on


BEGIN
   -- Architecture concurrent statements
   -- HDL Embedded Text Block 1 eb_ID
   -- hard-wired IDs
   board_id <= "0101";
   crate_id <= "01";

   -- HDL Embedded Text Block 2 ADC_CLK
   -- ADC_CLK 2
   A_CLK (0) <= CLK_25_PS;
   A_CLK (1) <= CLK_25_PS;
   A_CLK (2) <= CLK_25_PS;
   A_CLK (3) <= CLK_25_PS;                                        

   -- HDL Embedded Text Block 3 ADC_DATA
   -- ADC_DATA 3 
   adc_data_array (0) <= A0_D;
   adc_data_array (1) <= A1_D;
   adc_data_array (2) <= A2_D;
   adc_data_array (3) <= A3_D;                                       

   -- HDL Embedded Text Block 4 SRCLK
   -- SRCLK 4         
   D0_SRCLK <= SRCLK;
   D1_SRCLK <= SRCLK;
   D2_SRCLK <= SRCLK;
   D3_SRCLK <= SRCLK;                               

   -- HDL Embedded Text Block 5 T_CS
   -- T_CS 5
   T0_CS <= sensor_cs (0); 
   T1_CS <= sensor_cs (1);
   T2_CS <= sensor_cs (2);
   T3_CS <= sensor_cs (3);                                      

   -- HDL Embedded Text Block 6 MISC
   -- MISC 6     
   TRG_V <= '0';
   RS485_C_RE <= '1'; 
   RS485_C_DE <= '0';   
   RS485_E_RE <= '1';      
   RS485_E_DE <= '0'; 
   
   -- DENABLE <= '0'; -- domino wave stopped
   -- DENABLE <= '1'; -- domino wave running
   
   SRIN <= 'Z';
   EE_CS <= '1';
   -- LEDs are low active
   LED(0) <= '1';
   LED(1) <= '0'; -- on
   LED(2) <= '1';
                                 
   
   

   -- HDL Embedded Text Block 7 eb1
   D_T2 <= D_PLLLCK;

   -- HDL Embedded Text Block 8 eb2
   -- eb2 8                                        
   A1_T(0) <= dummy;
   A1_T(1) <= RSRLOAD_internal;
   A1_T(2) <= D0_SROUT;
   A1_T(3) <= D1_SROUT;


   -- ModuleWare code(v1.9) for instance 'I3' of 'assignment'
   DAC_CS <= dummy;

   -- ModuleWare code(v1.9) for instance 'I1' of 'inv'
   not_TEST_TRG <= NOT(TEST_TRG);

   -- ModuleWare code(v1.9) for instance 'I2' of 'or'
   TRG_OR <= TRG OR trigger_out;

   -- Instance port mappings.
   I_testboard_main : FAD_main
      GENERIC MAP (
         RAMADDRWIDTH64b => LOG2_OF_RAM_SIZE_64B
      )
      PORT MAP (
         CLK            => X_50M,
         SROUT_in_0     => D0_SROUT,
         SROUT_in_1     => D1_SROUT,
         SROUT_in_2     => D2_SROUT,
         SROUT_in_3     => D3_SROUT,
         adc_data_array => adc_data_array,
         adc_otr_array  => A_OTR,
         board_id       => board_id,
         crate_id       => crate_id,
         trigger        => TRG_OR,
         wiz_int        => W_INT,
         CLK_25_PS      => CLK_25_PS,
         CLK_50         => CLK_50,
         RSRLOAD        => RSRLOAD_internal,
         SRCLK          => SRCLK,
         adc_oeb        => OE_ADC,
         dac_cs         => dummy,
         denable        => DENABLE,
         drs_channel_id => D_A,
         drs_dwrite     => DWRITE,
         led            => D_T,
         mosi           => MOSI,
         sclk           => S_CLK,
         sensor_cs      => sensor_cs,
         wiz_addr       => W_A,
         wiz_cs         => W_CS,
         wiz_rd         => W_RD,
         wiz_reset      => W_RES,
         wiz_wr         => W_WR,
         sio            => MISO,
         wiz_data       => W_D
      );
   I0 : debouncer
      GENERIC MAP (
         WIDTH => 17
      )
      PORT MAP (
         clk         => CLK_50,
         trigger_in  => not_TEST_TRG,
         trigger_out => trigger_out
      );

   -- Implicit buffered output assignments
   RSRLOAD <= RSRLOAD_internal;

END struct;
