--	Package File Template
--
--	Purpose: This package defines supplemental types, subtypes, 
--		 constants, and functions 


library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
-- use IEEE.NUMERIC_STD.ALL;

package fad_definitions is

  
-- Declare constants

  type mac_type is array (0 to 2) of std_logic_vector (15 downto 0);
  type ip_type is array (0 to 3) of integer;
-- Network Settings

  constant MAC_ADDRESS : mac_type := (X"0011", X"9561", X"97B4"); 
  
  -- @ ETH zurich
  --  constant NETMASK : ip_type := (255, 255, 248, 0);
  --  constant IP_ADDRESS : ip_type := (192, 33, 99, 225);
  --  constant GATEWAY : ip_type := (192, 33, 96, 1);

  -- @ TU Dortmund
  constant NETMASK : ip_type := (255, 255, 255, 0);
  constant IP_ADDRESS : ip_type := (129, 217, 160, 119);
  constant GATEWAY : ip_type := (129, 217, 160, 1);

  constant FIRST_PORT : integer := 5000;
-- Network Settings End  
  
  constant PACKAGE_VERSION : std_logic_vector(7 downto 0) := X"01";
  constant PACKAGE_SUB_VERSION : std_logic_vector(7 downto 0) := X"02";
  constant PACKAGE_HEADER_LENGTH : integer := 22;
  constant PACKAGE_END_LENGTH : integer := 2; -- CRC and END-Flag
  
  constant W5300_S_INC : std_logic_vector(6 downto 0) := "1000000"; -- socket address offset

-- W5300 Registers
	constant W5300_BASE_ADR : std_logic_vector (9 downto 0) := (others => '0'); 
	constant W5300_MR : std_logic_vector (9 downto 0) := W5300_BASE_ADR + X"0";
	constant W5300_IR : std_logic_vector (9 downto 0) := W5300_BASE_ADR + X"2";
	constant W5300_IMR : std_logic_vector (9 downto 0) := W5300_BASE_ADR + X"4";
	constant W5300_SHAR : std_logic_vector (9 downto 0) := W5300_BASE_ADR + X"8";
	constant W5300_GAR : std_logic_vector (9 downto 0) := W5300_BASE_ADR + X"10";
	constant W5300_SUBR : std_logic_vector (9 downto 0) := W5300_BASE_ADR + X"14";
	constant W5300_SIPR : std_logic_vector (9 downto 0) := W5300_BASE_ADR + X"18";
	constant W5300_TMS01R : std_logic_vector (9 downto 0) := W5300_BASE_ADR + X"20";
	constant W5300_TMS23R : std_logic_vector (9 downto 0) := W5300_BASE_ADR + X"22";
  constant W5300_TMS45R : std_logic_vector (9 downto 0) := W5300_BASE_ADR + X"24";
  constant W5300_TMS67R : std_logic_vector (9 downto 0) := W5300_BASE_ADR + X"26";
  constant W5300_RMS01R : std_logic_vector (9 downto 0) := W5300_BASE_ADR + X"28";
  constant W5300_RMS23R : std_logic_vector (9 downto 0) := W5300_BASE_ADR + X"2A";
  constant W5300_RMS45R : std_logic_vector (9 downto 0) := W5300_BASE_ADR + X"2C";
  constant W5300_RMS67R : std_logic_vector (9 downto 0) := W5300_BASE_ADR + X"2E";        	
  constant W5300_MTYPER : std_logic_vector (9 downto 0) := W5300_BASE_ADR + X"30";
	
	constant W5300_S0_MR : std_logic_vector (9 downto 0) := W5300_BASE_ADR + "1000000000" + X"0";
	constant W5300_S0_CR : std_logic_vector (9 downto 0) := W5300_BASE_ADR + "1000000000" + X"2";
	constant W5300_S0_IMR : std_logic_vector (9 downto 0) := W5300_BASE_ADR + "1000000000" + X"4";
	constant W5300_S0_IR : std_logic_vector (9 downto 0) := W5300_BASE_ADR + "1000000000" + X"6";
	constant W5300_S0_SSR : std_logic_vector (9 downto 0) := W5300_BASE_ADR + "1000000000" + X"8";
	constant W5300_S0_PORTR : std_logic_vector (9 downto 0) := W5300_BASE_ADR + "1000000000" + X"A";
	constant W5300_S0_DPORTR : std_logic_vector (9 downto 0) := W5300_BASE_ADR + "1000000000" + X"12";
	constant W5300_S0_DIPR : std_logic_vector (9 downto 0) := W5300_BASE_ADR + "1000000000" + X"14";
	constant W5300_S0_TX_WRSR : std_logic_vector (9 downto 0) := W5300_BASE_ADR + "1000000000" + X"20";
	constant W5300_S0_TX_FSR : std_logic_vector (9 downto 0) := W5300_BASE_ADR + "1000000000" + X"24";
  constant W5300_S0_RX_RSR : std_logic_vector (9 downto 0) := W5300_BASE_ADR + "1000000000" + X"28";
	constant W5300_S0_TX_FIFOR : std_logic_vector (9 downto 0) := W5300_BASE_ADR + "1000000000" + X"2E";
  constant W5300_S0_RX_FIFOR : std_logic_vector (9 downto 0) := W5300_BASE_ADR + "1000000000" + X"30";
-- End W5300 registers	

-- 
  constant W5300_TX_FIFO_SIZE : integer := (15360 / 2); -- Socket TX FIFO-Size in 16 Bit Words

  constant LOG2_OF_RAM_SIZE_64B : integer := 15;
  constant RAM_SIZE_64B : integer := 2**LOG2_OF_RAM_SIZE_64B;
  constant RAM_SIZE_16B : integer := RAM_SIZE_64B * 4;

-- TYPE definitions
  type roi_max_type is array (0 to 8) of std_logic_vector (10 downto 0);
  type roi_array_type is array (0 to 35) of integer range 0 to 1024;
  type drs_s_cell_array_type is array (0 to 3) of std_logic_vector (9 downto 0);
  type adc_data_array_type is array (0 to 3) of std_logic_vector (11 downto 0);

  type dac_array_type is array (0 to 7) of integer range 0 to 2**16 - 1;
  type sensor_array_type is array (0 to 3) of integer range 0 to 2**16 - 1;
  
--  constant DEFAULT_ROI : roi_array_type := (115, 125, 100, 102, 155, 101,   0, 101, 106, 
--                                            181, 121, 189, 101, 101, 187,  56, 187, 101,
--                                              2, 141, 101, 100,  10, 100, 178, 101, 174, 
--                                             12, 181, 100, 102, 101, 102,   0, 101, 108); 
  constant DEFAULT_ROI : roi_array_type := (others => 150);
  
  constant DEFAULT_DAC : dac_array_type := (20972, 34079, 20526, 0, 28836, 28836, 28836, 28836);
  --constant DEFAULT_DAC : dac_array_type := (others => 0);

-- Commands
  constant CMD_START : std_logic_vector       := X"C0";
  constant CMD_STOP : std_logic_vector        := X"30";
  constant CMD_TRIGGER : std_logic_vector     := X"A0";

  constant CMD_TRIGGER_C : std_logic_vector   := X"B0";
  constant CMD_TRIGGER_S : std_logic_vector   := X"20";
  constant CMD_READ : std_logic_vector        := X"0A";
  constant CMD_WRITE : std_logic_vector       := X"05";

  constant CMD_DENABLE : std_logic_vector     := X"06";
  constant CMD_DDISABLE : std_logic_vector    := X"07";
  constant CMD_DWRITE_RUN : std_logic_vector  := X"08";
  constant CMD_DWRITE_STOP : std_logic_vector := X"09";
-- Declare functions and procedure


end fad_definitions;


