#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <sys/ioctl.h>



#include "dev/pci/sis1100_var.h"
#include "sis3100_vme_calls.h"



#define VME_WRITE_MODE_D32	 0x0      
#define VME_WRITE_MODE_DMA_D32	 0x1      
#define VME_WRITE_MODE_BLT32	 0x2      
#define VME_WRITE_MODE_MBLT64	 0x3

#define VME_READ_MODE_D32	 0x0      
#define VME_READ_MODE_DMA_D32	 0x1      
#define VME_READ_MODE_BLT32	 0x2      
#define VME_READ_MODE_MBLT64	 0x3
#define VME_READ_MODE_2EVME	 0x4



/*===========================================================================*/
/* Globals					  			     */
/*===========================================================================*/

#define MAX_NUMBER_OF_PRINTS 0x10      
#define MAX_NUMBER_LWORDS 0x1000000       /* 64MByte */

u_int32_t wblt_data[MAX_NUMBER_LWORDS] ;
u_int32_t rblt_data[MAX_NUMBER_LWORDS] ;

u_int32_t test1_data[16] ;




/*===========================================================================*/
/* Prototypes					  			     */
/*===========================================================================*/

int vme_memory_test(int ip, u_int32_t vme_start_addr, u_int32_t no_of_lwords, int vme_write_mode, int vme_read_mode ) ;


/****************************************************************************/
int main(int argc, char* argv[])
{


int p;
u_int32_t addr ;
u_int32_t no_of_lwords ;

int return_code ;

int vme_wr_mode, vme_rd_mode ;




test1_data[0]   =   0x12345678 ;
test1_data[1]   =   0x87654321 ;
test1_data[2]   =   0x11224488 ;
test1_data[3]   =   0x88442211 ;
test1_data[4]   =   0xAA559966 ;
test1_data[5]   =   0x66AA5599 ;
test1_data[6]   =   0x9966AA55 ;
test1_data[7]   =   0x559966AA ;
test1_data[8]   =   0xffffffff ;
test1_data[9]   =   0x00000000 ;
test1_data[10]  =   0xFF00FF00 ;
test1_data[11]  =   0x00FF00FF ;
test1_data[12]  =   0xFFFF0000 ;
test1_data[13]  =   0x0000FFFF ;
test1_data[14]  =   0xF0F0F0F0 ;
test1_data[15]  =   0x0F0F0F0F ;


/* open VME */
   if ((p=open("/tmp/sis1100_00remote", O_RDWR, 0))<0) {
     printf("error on opening VME environment\n");
     return -1;
   }

if (argc<3)
  {
   printf("usage:  VME_START_ADDRESS  NO_OF_LWORDS  \n");
  return -1;
  }

addr         = strtoul(argv[1],NULL,0);
no_of_lwords = strtoul(argv[2],NULL,0) ;




/******************************************************************/
/*                                                                */
/* Test VME RAM from PCI                    */
/*                                                                */
/******************************************************************/

/*   printf("usage:  VME_WRITE/READ_MODE = 0  D32 \n");     */
/*   printf("usage:  VME_WRITE/READ_MODE = 1  DMA D32 \n"); */
/*   printf("usage:  VME_WRITE/READ_MODE = 2  BLT32  \n");  */
/*   printf("usage:  VME_WRITE/READ_MODE = 3  MBLT64 \n");  */
/*   printf("usage:  VME_WRITE/READ_MODE = 4  2EVME  \n");  */




for (vme_rd_mode=0;vme_rd_mode<5;vme_rd_mode++)    { 
   for (vme_wr_mode=0;vme_wr_mode<2;vme_wr_mode++)    { 
    return_code = vme_memory_test(p, addr, no_of_lwords, vme_wr_mode, vme_rd_mode) ;
    if (return_code != 0)  {
        printf("Error in vme_memory_test:  start_addr = 0x%08x   no_of_lwords = 0x%08x\n", addr, no_of_lwords );         
        return -1 ;
       }
    printf("Test VME_MEMORY_TEST from PCI with VME_WRITE_MODE = %1d  and  VME_READ_MODE = %1d OK\n",vme_wr_mode, vme_rd_mode);         
    } /* for vme_wr_mode */
 } /* for vme_rd_mode */



close(p);
return 0 ;
}








/***************************************************/
      


int vme_memory_test(int ip, u_int32_t vme_start_addr, u_int32_t no_of_lwords, int vme_write_mode, int vme_read_mode )
{
/*
#define MAX_NUMBER_OF_PRINTS 0x10      
#define MAX_NUMBER_LWORDS 0x400000        
u_int32_t wblt_data[MAX_NUMBER_LWORDS] ;
u_int32_t rblt_data[MAX_NUMBER_LWORDS] ;
*/
u_int32_t addr, data ;
u_int32_t get_lwords ;
u_int32_t put_lwords ;

int i;
int error_cnt ;
int return_code ;



if (no_of_lwords > MAX_NUMBER_LWORDS)  {
     printf("no_of_lwords (0x%08x) must be lower then MAX_NUMBER_LWORDS (0x%08x)\n",no_of_lwords, MAX_NUMBER_LWORDS);
     return -1;
   }

if (no_of_lwords == 0)  {
     printf("no_of_lwords (0x%08x) must be higher then 1 \n",no_of_lwords);
     return -1;
   }
/* check address if 4,8, bzw 8,10 */


/******************************************************************/
/*                                                                */
/* step 1:   write increment pattern                              */
/*                                                                */
/******************************************************************/
    /* prepare data */
    for (i=0;i<no_of_lwords;i++)    { wblt_data[i] = i ;  }

/*
#define VME_WRITE_MODE_D32	 0x0      
#define VME_WRITE_MODE_DMA_D32	 0x1      
#define VME_WRITE_MODE_BLT32	 0x2      
#define VME_WRITE_MODE_MBLT64	 0x3
*/

    /* VME write data */
    addr =  vme_start_addr ;                     
    switch (vme_write_mode) {
	case VME_WRITE_MODE_D32: 
	   for (i=0; i<no_of_lwords; i++)  {
             return_code = vme_A32D32_write(ip, addr, wblt_data[i]) ;
             if(return_code != 0) {
                printf("return Error vme_A32D32_write:   return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
                return -1 ; 
             }
           addr = addr + 4;
           } /* for */
         break;
	case VME_WRITE_MODE_DMA_D32: 
           return_code =   vme_A32DMA_D32_write(ip, addr, wblt_data, no_of_lwords, &put_lwords) ;
           if(return_code != 0) {
              printf("return Error vme_A32DMA_D32_write:   return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
              return -1 ; 
             }
           if(no_of_lwords != put_lwords) {
              printf("length Error vme_A32DMA_D32_write:   must length = 0x%08x  written length = 0x%08x\n", no_of_lwords, put_lwords );         
              return -1 ; 
             }
         break;
	case VME_WRITE_MODE_BLT32: 
           return_code =   vme_A32BLT32_write(ip, addr, wblt_data, no_of_lwords, &put_lwords) ;
           if(return_code != 0) {
              printf("return Error vme_A32BLT32_write:   return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
              return -1 ; 
             }
           if(no_of_lwords != put_lwords) {
              printf("length Error vme_A32BLT32_write:   must length = 0x%08x  written length = 0x%08x\n", no_of_lwords, put_lwords );         
              return -1 ; 
             }
         break;
	case VME_WRITE_MODE_MBLT64: 
           return_code =   vme_A32MBLT64_write(ip, addr, wblt_data, no_of_lwords, &put_lwords) ;
           if(return_code != 0) {
              printf("return Error vme_A32MBLT64_write:   return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
              return -1 ; 
             }
           if(no_of_lwords != put_lwords) {
              printf("length Error vme_A32MBLT64_write:   must length = 0x%08x  written length = 0x%08x\n", no_of_lwords, put_lwords );         
              return -1 ; 
             }
         break;
 	default:
           printf("Error in vme_memory_test:  not defined VME_WRITE_MODE \n");         
           return -1;
    } /* end switch */


  /* read data */
    addr =  vme_start_addr ;                     
    switch (vme_read_mode) {
	case VME_READ_MODE_D32: 
	   for (i=0; i<no_of_lwords; i++)  {
             return_code =  vme_A32D32_read(ip, addr, &data) ;
             if(return_code != 0) {
                printf("return Error vme_A32D32_read:   return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
                return -1 ; 
             }
             rblt_data[i] = data  ;
             addr = addr + 4;
           } /* for */
         break;
	case VME_READ_MODE_DMA_D32: 
           return_code =   vme_A32DMA_D32_read(ip, addr, rblt_data, no_of_lwords, &get_lwords) ;
           if(return_code != 0) {
              printf("return Error vme_A32DMA_D32_read:   return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
              return -1 ; 
             }
           if(no_of_lwords != get_lwords) {
              printf("length Error vme_A32DMA_D32_read:   must length = 0x%08x  read length = 0x%08x\n", no_of_lwords, get_lwords );         
              return -1 ; 
             }
         break;
	case VME_READ_MODE_BLT32: 
           return_code =   vme_A32BLT32_read(ip, addr, rblt_data, no_of_lwords, &get_lwords) ;
           if(return_code != 0) {
              printf("return Error vme_A32BLT32_read:   return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
              return -1 ; 
             }
           if(no_of_lwords != get_lwords) {
              printf("length Error vme_A32BLT32_read:   must length = 0x%08x  read length = 0x%08x\n", no_of_lwords, get_lwords );         
              return -1 ; 
             }
         break;
	case VME_READ_MODE_MBLT64: 
           return_code =   vme_A32MBLT64_read(ip, addr, rblt_data, no_of_lwords, &get_lwords) ;
           if(return_code != 0) {
              printf("return Error vme_A32MBLT64_read:   return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
              return -1 ; 
             }
           if(no_of_lwords != get_lwords) {
              printf("length Error vme_A32MBLT64_read:   must length = 0x%08x  read length = 0x%08x\n", no_of_lwords, get_lwords );         
              return -1 ; 
             }
         break;

	case VME_READ_MODE_2EVME: 
           return_code =   vme_A32_2EVME_read(ip, addr, rblt_data, no_of_lwords, &get_lwords) ;
           if(return_code != 0) {
              printf("return Error vme_A32_2EVME_read:   return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
              return -1 ; 
             }
           if(no_of_lwords != get_lwords) {
              printf("length Error vme_A32_2EVME_read:   must length = 0x%08x  read length = 0x%08x\n", no_of_lwords, get_lwords );         
              return -1 ; 
             }
         break;
 	default:
           printf("Error in vme_memory_test:  not defined VME_READ_MODE \n");         
           return -1;
    } /* end switch */




     /* check data */
     error_cnt =  0 ;
     for (i=0;(i)<no_of_lwords;i++)
       {
          if (wblt_data[i] != rblt_data[i])  
           {
             printf(" Error at i = : 0x%08x    written = : 0x%08x   read = : 0x%08x\n", i, wblt_data[i], rblt_data[i]);
             error_cnt = error_cnt + 1;
             if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
           }
       }




/******************************************************************/
/*                                                                */
/* step 2:   bit shift pattern                                    */
/*                                                                */
/******************************************************************/
    /* prepare data */
    for (i=0;i<no_of_lwords;i++)    { wblt_data[i] = (0x1 << (i&0x1f)) ;  }
/*   for (i=0;i<no_of_lwords;i++)    { printf("w = 0x%08x \n", wblt_data[i]);  } */

    /* write data */
    addr =  vme_start_addr ;                     
    switch (vme_write_mode) {
	case VME_WRITE_MODE_D32: 
	   for (i=0; i<no_of_lwords; i++)  {
             return_code = vme_A32D32_write(ip, addr, wblt_data[i]) ;
             if(return_code != 0) {
                printf("return Error vme_A32D32_write:   return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
                return -1 ; 
             }
           addr = addr + 4;
           } /* for */
         break;
	case VME_WRITE_MODE_DMA_D32: 
           return_code =   vme_A32DMA_D32_write(ip, addr, wblt_data, no_of_lwords, &put_lwords) ;
           if(return_code != 0) {
              printf("return Error vme_A32DMA_D32_write:   return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
              return -1 ; 
             }
           if(no_of_lwords != put_lwords) {
              printf("length Error vme_A32DMA_D32_write:   must length = 0x%08x  written length = 0x%08x\n", no_of_lwords, put_lwords );         
              return -1 ; 
             }
         break;
	case VME_WRITE_MODE_BLT32: 
           return_code =   vme_A32BLT32_write(ip, addr, wblt_data, no_of_lwords, &put_lwords) ;
           if(return_code != 0) {
              printf("return Error vme_A32BLT32_write:   return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
              return -1 ; 
             }
           if(no_of_lwords != put_lwords) {
              printf("length Error vme_A32BLT32_write:   must length = 0x%08x  written length = 0x%08x\n", no_of_lwords, put_lwords );         
              return -1 ; 
             }
         break;
	case VME_WRITE_MODE_MBLT64: 
           return_code =   vme_A32MBLT64_write(ip, addr, wblt_data, no_of_lwords, &put_lwords) ;
           if(return_code != 0) {
              printf("return Error vme_A32MBLT64_write:   return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
              return -1 ; 
             }
           if(no_of_lwords != put_lwords) {
              printf("length Error vme_A32MBLT64_write:   must length = 0x%08x  written length = 0x%08x\n", no_of_lwords, put_lwords );         
              return -1 ; 
             }
         break;
 	default:
           printf("Error in vme_memory_test:  not defined VME_WRITE_MODE \n");         
           return -1;
    } /* end switch */




    /* read data */
    addr =  vme_start_addr ;                     
    switch (vme_read_mode) {
	case VME_READ_MODE_D32: 
	   for (i=0; i<no_of_lwords; i++)  {
             return_code =  vme_A32D32_read(ip, addr, &data) ;
             if(return_code != 0) {
                printf("return Error vme_A32D32_read:   return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
                return -1 ; 
             }
             rblt_data[i] = data  ;
             addr = addr + 4;
           } /* for */
         break;
	case VME_READ_MODE_DMA_D32: 
           return_code =   vme_A32DMA_D32_read(ip, addr, rblt_data, no_of_lwords, &get_lwords) ;
           if(return_code != 0) {
              printf("return Error vme_A32DMA_D32_read:   return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
              return -1 ; 
             }
           if(no_of_lwords != get_lwords) {
              printf("length Error vme_A32DMA_D32_read:   must length = 0x%08x  read length = 0x%08x\n", no_of_lwords, get_lwords );         
              return -1 ; 
             }
         break;
	case VME_READ_MODE_BLT32: 
           return_code =   vme_A32BLT32_read(ip, addr, rblt_data, no_of_lwords, &get_lwords) ;
           if(return_code != 0) {
              printf("return Error vme_A32BLT32_read:   return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
              return -1 ; 
             }
           if(no_of_lwords != get_lwords) {
              printf("length Error vme_A32BLT32_read:   must length = 0x%08x  read length = 0x%08x\n", no_of_lwords, get_lwords );         
              return -1 ; 
             }
         break;
	case VME_READ_MODE_MBLT64: 
           return_code =   vme_A32MBLT64_read(ip, addr, rblt_data, no_of_lwords, &get_lwords) ;
           if(return_code != 0) {
              printf("return Error vme_A32MBLT64_read:   return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
              return -1 ; 
             }
           if(no_of_lwords != get_lwords) {
              printf("length Error vme_A32MBLT64_read:   must length = 0x%08x  read length = 0x%08x\n", no_of_lwords, get_lwords );         
              return -1 ; 
             }
         break;
	case VME_READ_MODE_2EVME: 
           return_code =   vme_A32_2EVME_read(ip, addr, rblt_data, no_of_lwords, &get_lwords) ;
           if(return_code != 0) {
              printf("return Error vme_A32_2EVME_read:   return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
              return -1 ; 
             }
           if(no_of_lwords != get_lwords) {
              printf("length Error vme_A32_2EVME_read:   must length = 0x%08x  read length = 0x%08x\n", no_of_lwords, get_lwords );         
              return -1 ; 
             }
         break;

 	default:
           printf("Error in vme_memory_test:  not defined VME_READ_MODE \n");         
           return -1;
    } /* end switch */






     /* check data */
     error_cnt =  0 ;
     for (i=0;(i)<no_of_lwords;i++)
       {
          if (wblt_data[i] != rblt_data[i])  
           {
             printf(" Error at i = : 0x%08x    written = : 0x%08x   read = : 0x%08x\n", i, wblt_data[i], rblt_data[i]);
             error_cnt = error_cnt + 1;
             if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
           }
       }


/******************************************************************/
/*                                                                */
/* step 3:    pattern                                             */
/*                                                                */
/******************************************************************/
    /* prepare data */
    for (i=0;i<no_of_lwords;i++)    { wblt_data[i] =  test1_data[i&0xf] ;  }
/*    for (i=0;i<no_of_lwords;i++)    { printf("w = 0x%08x \n", wblt_data[i]);  }  */

    /* write data */
    addr =  vme_start_addr ;                     
    switch (vme_write_mode) {
	case VME_WRITE_MODE_D32: 
	   for (i=0; i<no_of_lwords; i++)  {
             return_code = vme_A32D32_write(ip, addr, wblt_data[i]) ;
             if(return_code != 0) {
                printf("return Error vme_A32D32_write:   return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
                return -1 ; 
             }
           addr = addr + 4;
           } /* for */
         break;
	case VME_WRITE_MODE_DMA_D32: 
           return_code =   vme_A32DMA_D32_write(ip, addr, wblt_data, no_of_lwords, &put_lwords) ;
           if(return_code != 0) {
              printf("return Error vme_A32DMA_D32_write:   return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
              return -1 ; 
             }
           if(no_of_lwords != put_lwords) {
              printf("length Error vme_A32DMA_D32_write:   must length = 0x%08x  written length = 0x%08x\n", no_of_lwords, put_lwords );         
              return -1 ; 
             }
         break;
	case VME_WRITE_MODE_BLT32: 
           return_code =   vme_A32BLT32_write(ip, addr, wblt_data, no_of_lwords, &put_lwords) ;
           if(return_code != 0) {
              printf("return Error vme_A32BLT32_write:   return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
              return -1 ; 
             }
           if(no_of_lwords != put_lwords) {
              printf("length Error vme_A32BLT32_write:   must length = 0x%08x  written length = 0x%08x\n", no_of_lwords, put_lwords );         
              return -1 ; 
             }
         break;
	case VME_WRITE_MODE_MBLT64: 
           return_code =   vme_A32MBLT64_write(ip, addr, wblt_data, no_of_lwords, &put_lwords) ;
           if(return_code != 0) {
              printf("return Error vme_A32MBLT64_write:   return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
              return -1 ; 
             }
           if(no_of_lwords != put_lwords) {
              printf("length Error vme_A32MBLT64_write:   must length = 0x%08x  written length = 0x%08x\n", no_of_lwords, put_lwords );         
              return -1 ; 
             }
         break;
 	default:
           printf("Error in vme_memory_test:  not defined VME_WRITE_MODE \n");         
           return -1;
    } /* end switch */




    /* read data */
    addr =  vme_start_addr ;                     
    switch (vme_read_mode) {
	case VME_READ_MODE_D32: 
	   for (i=0; i<no_of_lwords; i++)  {
             return_code =  vme_A32D32_read(ip, addr, &data) ;
             if(return_code != 0) {
                printf("return Error vme_A32D32_read:   return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
                return -1 ; 
             }
             rblt_data[i] = data  ;
             addr = addr + 4;
           } /* for */
         break;
	case VME_READ_MODE_DMA_D32: 
           return_code =   vme_A32DMA_D32_read(ip, addr, rblt_data, no_of_lwords, &get_lwords) ;
           if(return_code != 0) {
              printf("return Error vme_A32DMA_D32_read:   return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
              return -1 ; 
             }
           if(no_of_lwords != get_lwords) {
              printf("length Error vme_A32DMA_D32_read:   must length = 0x%08x  read length = 0x%08x\n", no_of_lwords, get_lwords );         
              return -1 ; 
             }
         break;
	case VME_READ_MODE_BLT32: 
           return_code =   vme_A32BLT32_read(ip, addr, rblt_data, no_of_lwords, &get_lwords) ;
           if(return_code != 0) {
              printf("return Error vme_A32BLT32_read:   return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
              return -1 ; 
             }
           if(no_of_lwords != get_lwords) {
              printf("length Error vme_A32BLT32_read:   must length = 0x%08x  read length = 0x%08x\n", no_of_lwords, get_lwords );         
              return -1 ; 
             }
         break;
	case VME_READ_MODE_MBLT64: 
           return_code =   vme_A32MBLT64_read(ip, addr, rblt_data, no_of_lwords, &get_lwords) ;
           if(return_code != 0) {
              printf("return Error vme_A32MBLT64_read:   return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
              return -1 ; 
             }
           if(no_of_lwords != get_lwords) {
              printf("length Error vme_A32MBLT64_read:   must length = 0x%08x  read length = 0x%08x\n", no_of_lwords, get_lwords );         
              return -1 ; 
             }
         break;
	case VME_READ_MODE_2EVME: 
           return_code =   vme_A32_2EVME_read(ip, addr, rblt_data, no_of_lwords, &get_lwords) ;
           if(return_code != 0) {
              printf("return Error vme_A32_2EVME_read:   return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
              return -1 ; 
             }
           if(no_of_lwords != get_lwords) {
              printf("length Error vme_A32_2EVME_read:   must length = 0x%08x  read length = 0x%08x\n", no_of_lwords, get_lwords );         
              return -1 ; 
             }
         break;


 	default:
           printf("Error in vme_memory_test:  not defined VME_READ_MODE \n");         
           return -1;
    } /* end switch */






     /* check data */
     error_cnt =  0 ;
     for (i=0;(i)<no_of_lwords;i++)
       {
          if (wblt_data[i] != rblt_data[i])  
           {
             printf(" Error at i = : 0x%08x    written = : 0x%08x   read = : 0x%08x\n", i, wblt_data[i], rblt_data[i]);
             error_cnt = error_cnt + 1;
             if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
           }
       }




/******************************************************************/
/*                                                                */
/* step 4:    random                                              */
/*                                                                */
/******************************************************************/
    /* prepare data */
    for (i=0;i<no_of_lwords;i++)    { wblt_data[i] =  random() ;  }
/*    for (i=0;i<no_of_lwords;i++)    { printf("w = 0x%08x \n", wblt_data[i]);  }   */

    /* write data */
    addr =  vme_start_addr ;                     
    switch (vme_write_mode) {
	case VME_WRITE_MODE_D32: 
	   for (i=0; i<no_of_lwords; i++)  {
             return_code = vme_A32D32_write(ip, addr, wblt_data[i]) ;
             if(return_code != 0) {
                printf("return Error vme_A32D32_write:   return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
                return -1 ; 
             }
           addr = addr + 4;
           } /* for */
         break;
	case VME_WRITE_MODE_DMA_D32: 
           return_code =   vme_A32DMA_D32_write(ip, addr, wblt_data, no_of_lwords, &put_lwords) ;
           if(return_code != 0) {
              printf("return Error vme_A32DMA_D32_write:   return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
              return -1 ; 
             }
           if(no_of_lwords != put_lwords) {
              printf("length Error vme_A32DMA_D32_write:   must length = 0x%08x  written length = 0x%08x\n", no_of_lwords, put_lwords );         
              return -1 ; 
             }
         break;
	case VME_WRITE_MODE_BLT32: 
           return_code =   vme_A32BLT32_write(ip, addr, wblt_data, no_of_lwords, &put_lwords) ;
           if(return_code != 0) {
              printf("return Error vme_A32BLT32_write:   return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
              return -1 ; 
             }
           if(no_of_lwords != put_lwords) {
              printf("length Error vme_A32BLT32_write:   must length = 0x%08x  written length = 0x%08x\n", no_of_lwords, put_lwords );         
              return -1 ; 
             }
         break;
	case VME_WRITE_MODE_MBLT64: 
           return_code =   vme_A32MBLT64_write(ip, addr, wblt_data, no_of_lwords, &put_lwords) ;
           if(return_code != 0) {
              printf("return Error vme_A32MBLT64_write:   return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
              return -1 ; 
             }
           if(no_of_lwords != put_lwords) {
              printf("length Error vme_A32MBLT64_write:   must length = 0x%08x  written length = 0x%08x\n", no_of_lwords, put_lwords );         
              return -1 ; 
             }
         break;
 	default:
           printf("Error in vme_memory_test:  not defined VME_WRITE_MODE \n");         
           return -1;
    } /* end switch */



    /* read data */
    addr =  vme_start_addr ;                     
    switch (vme_read_mode) {
	case VME_READ_MODE_D32: 
	   for (i=0; i<no_of_lwords; i++)  {
             return_code =  vme_A32D32_read(ip, addr, &data) ;
             if(return_code != 0) {
                printf("return Error vme_A32D32_read:   return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
                return -1 ; 
             }
             rblt_data[i] = data  ;
             addr = addr + 4;
           } /* for */
         break;
	case VME_READ_MODE_DMA_D32: 
           return_code =   vme_A32DMA_D32_read(ip, addr, rblt_data, no_of_lwords, &get_lwords) ;
           if(return_code != 0) {
              printf("return Error vme_A32DMA_D32_read:   return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
              return -1 ; 
             }
           if(no_of_lwords != get_lwords) {
              printf("length Error vme_A32DMA_D32_read:   must length = 0x%08x  read length = 0x%08x\n", no_of_lwords, get_lwords );         
              return -1 ; 
             }
         break;
	case VME_READ_MODE_BLT32: 
           return_code =   vme_A32BLT32_read(ip, addr, rblt_data, no_of_lwords, &get_lwords) ;
           if(return_code != 0) {
              printf("return Error vme_A32BLT32_read:   return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
              return -1 ; 
             }
           if(no_of_lwords != get_lwords) {
              printf("length Error vme_A32BLT32_read:   must length = 0x%08x  read length = 0x%08x\n", no_of_lwords, get_lwords );         
              return -1 ; 
             }
         break;
	case VME_READ_MODE_MBLT64: 
           return_code =   vme_A32MBLT64_read(ip, addr, rblt_data, no_of_lwords, &get_lwords) ;
           if(return_code != 0) {
              printf("return Error vme_A32MBLT64_read:   return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
              return -1 ; 
             }
           if(no_of_lwords != get_lwords) {
              printf("length Error vme_A32MBLT64_read:   must length = 0x%08x  read length = 0x%08x\n", no_of_lwords, get_lwords );         
              return -1 ; 
             }
         break;
	case VME_READ_MODE_2EVME: 
           return_code =   vme_A32_2EVME_read(ip, addr, rblt_data, no_of_lwords, &get_lwords) ;
           if(return_code != 0) {
              printf("return Error vme_A32_2EVME_read:   return_code = 0x%08x  at address = 0x%08x\n", return_code, addr );         
              return -1 ; 
             }
           if(no_of_lwords != get_lwords) {
              printf("length Error vme_A32_2EVME_read:   must length = 0x%08x  read length = 0x%08x\n", no_of_lwords, get_lwords );         
              return -1 ; 
             }
         break;
 	default:
           printf("Error in vme_memory_test:  not defined VME_READ_MODE \n");         
           return -1;
    } /* end switch */





     /* check data */
     error_cnt =  0 ;
     for (i=0;(i)<no_of_lwords;i++)
       {
          if (wblt_data[i] != rblt_data[i])  
           {
             printf(" Error at i = : 0x%08x    written = : 0x%08x   read = : 0x%08x\n", i, wblt_data[i], rblt_data[i]);
             error_cnt = error_cnt + 1;
             if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
           }
       }




  if (error_cnt == 0) {
     return 0 ; }
    else {
     return -1 ;}

}
































