/* $ZEL: sis1100_dsp.c,v 1.2 2004/05/27 23:10:19 wuestner Exp $ */

/*
 * Copyright (c) 2003-2004
 * 	Peter Wuestner.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "sis1100_sc.h"

#if !defined(__NetBSD__) && ! defined(__linux__)
#error Invalid or Unknown Operating System
#endif

int
sis1100_dsp_reset(struct sis1100_softc* sc, struct sis1100_fdata* fd)
{
    int error;

    if (!sc->dsp_present) return ENXIO;
    switch (sc->remote_hw) {
        case sis1100_hw_vme:
            SEM_LOCK(sc->sem_hw);
            error=sis3100writeremreg(sc, dsp_sc, sis3100_dsp_boot_ctrl, 1);
            if (!error) error=sis3100writeremreg(sc, dsp_sc, sis3100_dsp_run<<16, 1);
            SEM_UNLOCK(sc->sem_hw);
            break;
        case sis1100_hw_camac:
            SEM_LOCK(sc->sem_hw);
            error=sis5100writeremreg(sc, dsp_sc, sis5100_dsp_boot_ctrl, 1);
            if (!error) error=sis5100writeremreg(sc, dsp_sc, sis5100_dsp_run<<16, 1);
            SEM_UNLOCK(sc->sem_hw);
            break;
        default:
            return ENOTTY;
    }
/*
    if (error) {
        pINFO(sc, "dsp_reset: error=0x%x", error);
        return EIO;
    }
*/
    return error?EIO:0;
}

int
sis1100_dsp_start(struct sis1100_softc* sc, struct sis1100_fdata* fd)
{
    int error;

    if (!sc->dsp_present) return ENXIO;
    switch (sc->remote_hw) {
        case sis1100_hw_vme:
            error=sis3100writeremreg(sc, dsp_sc, sis3100_dsp_run, 0);
            break;
        case sis1100_hw_camac:
            error=sis5100writeremreg(sc, dsp_sc, sis5100_dsp_run, 0);
            break;
        default:
            return ENOTTY;
    }
    return error?EIO:0;
}

#define SHARCRAM  0x81200000
#define D48REG    0x81300000

int
sis1100_dsp_load(struct sis1100_softc* sc, struct sis1100_fdata* fd,
    struct sis1100_dsp_code* d)
{
    u_int8_t* code=d->src;
    u_int8_t v[6];
    u_int32_t addr, w0, w12;
    int error=0, i, j;

    if (!sc->dsp_present) return ENXIO;
if (sc->remote_hw!=sis1100_hw_vme) return ENXIO;

    if (d->dst%4) return EINVAL;
    if (d->size%6) return EINVAL;

    addr=d->dst+SHARCRAM;
    for (i=d->size/6; i && !error; i--) {
        for (j=0; j<6; j++) {
#ifdef __NetBSD__
            v[j]=fubyte(code);
#elif __linux__
            get_user(v[j], code);
#endif
            code++;
        }
#if 0
        pINFO("%08x %02x%02x%02x%02x%02x%02x",
                (addr-SHARCRAM)>>2,
                v[0], v[1], v[2], v[3], v[4], v[5]);
#endif
        w0=v[5]|(v[4]<<8);
        w12=(v[3] | (v[2]<<8) | (v[1]<<16) | (v[0]<<24));
        SEM_LOCK(sc->sem_hw);
        error=sis1100_remote_reg_write(sc, D48REG, w0, 1);
        error|=sis1100_remote_reg_write(sc, addr, w12, 1);
        SEM_UNLOCK(sc->sem_hw);
        addr+=4;
    }
    return error?EIO:0;
}
