/***************************************************************************/
/*                                                                         */
/*  Filename: multievent_wrap_internalTriggerStop_switchBank.c             */
/*                                                                         */
/*  Funktion:  bank1 and bank2 in bank switch mode                         */
/*                                                                         */
/* 1. Reset SIS330x                                                        */
/* 2a. write Configuration register                                        */
/* 2b. write StopDelay                                                     */
/* 2c. write Trigger Setup register                                        */
/* 2d. write Trigger Threshold register                                    */
/* 2e. write Trigger Falg Clear Counter register                           */
/* 2f. write Configuration register                                        */
/* 2g. write Acquisition register                                          */
/* 3. Start Sampling in AUTO_BANK_SWITCH Mode                              */
/* 4. Readout Loop                                                         */
/* 4.1.1  wait for bank1 full                                              */
/* 4.1.2 Read data (Bank1 event counter,                                   */
/*                  address counter, event directory, ADC data)            */
/* 4.1.3 Clear Bank1 Full Flag                                             */
/* 4.2.1  wait for bank2 full                                              */
/* 4.2.2 Read data (Bank2 event counter,                                   */
/*                  address counter, event directory, ADC data)            */
/* 4.2.3 Clear Bank2 Full Flag                                             */
/*                                                                         */
/* ----------------------------------------------------------------------- */
/*                                                                         */
/*  Autor:                TH                                               */
/*  date:                 24.05.2002                                       */
/*  last modification:    24.05.2002                                       */
/*                                                                         */
/* ----------------------------------------------------------------------- */
/*                                                                         */
/*  SIS  Struck Innovative Systeme GmbH                                    */
/*                                                                         */
/*  Harksheider Str. 102A                                                  */
/*  22399 Hamburg                                                          */
/*                                                                         */
/*  Tel. +49 (0)40 60 87 305 0                                             */
/*  Fax  +49 (0)40 60 87 305 20                                            */
/*                                                                         */
/*  http://www.struck.de                                                   */
/*                                                                         */
/*   2002                                                                 */
/*                                                                         */
/***************************************************************************/

#define gnuplot 

#define printeventDir 
/* #define write_2_disk */



#define _GNU_SOURCE
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <sys/ioctl.h>

#include "dev/pci/sis1100_var.h"
#include "sis3100_vme_calls.h"

#include "../../header/sis3300.h"

#define MAX_NUMBER_LWORDS  0x100000

#define MAX_ADC_MEM_SIZE_LWORDS    0x20000
#define MAX_EVENTDIR_SIZE_LWORDS     0x400

unsigned int gl_blt1_data[MAX_ADC_MEM_SIZE_LWORDS] ;
unsigned int gl_blt2_data[MAX_ADC_MEM_SIZE_LWORDS] ;
unsigned int gl_blt3_data[MAX_ADC_MEM_SIZE_LWORDS] ;
unsigned int gl_blt4_data[MAX_ADC_MEM_SIZE_LWORDS] ;

unsigned short gl_ADC1_data[MAX_ADC_MEM_SIZE_LWORDS] ;
unsigned short gl_ADC2_data[MAX_ADC_MEM_SIZE_LWORDS] ;
unsigned short gl_ADC3_data[MAX_ADC_MEM_SIZE_LWORDS] ;
unsigned short gl_ADC4_data[MAX_ADC_MEM_SIZE_LWORDS] ;
unsigned short gl_ADC5_data[MAX_ADC_MEM_SIZE_LWORDS] ;
unsigned short gl_ADC6_data[MAX_ADC_MEM_SIZE_LWORDS] ;
unsigned short gl_ADC7_data[MAX_ADC_MEM_SIZE_LWORDS] ;
unsigned short gl_ADC8_data[MAX_ADC_MEM_SIZE_LWORDS] ;

unsigned int gl_eventdir_data[MAX_EVENTDIR_SIZE_LWORDS] ;


FILE *used_file ;

int multievent_test1(int p, u_int32_t vme_base_addr ) ;


/****************************************************************************/

int main(int argc, char* argv[])
{


int p;
int mod_base;

u_int32_t addr ;
u_int32_t data ;

int return_code ;



/* open VME */
   if ((p=open("/tmp/sis1100", O_RDWR, 0))<0) {
     fprintf(stderr,"error on opening VME environment\n");
     return -1;
   }

if (argc<2)  {
   fprintf(stderr,"usage:  SIS330x_VME_BASE_ADDRESS     \n");
  return -1;
  }

  mod_base           = strtoul(argv[1],NULL,0) ;

  addr = mod_base + SIS3300_MODID ;                    /* ID */

  return_code =  vme_A32D32_read(p, addr, &data ) ;
  if (return_code != 0) { fprintf(stderr,"vme_A32D32_read:return_code = 0x%08x at addr = 0x%08x\n",return_code,addr); return -1 ;}

  fprintf(stderr,"\n");
  fprintf(stderr," Modul Identification register:  0x%08x\n", data );
  fprintf(stderr,"\n");


  return_code = multievent_test1(p, mod_base) ;


close(p);
return 0;
}




#define PAGE_LWORDS_4K   0x1000

int multievent_test1(int p, unsigned int vme_base_addr)
{
unsigned int mod_base ;
int no_of_lwords ;

unsigned int addr ;
unsigned int data ;
unsigned int get_lwords ;
unsigned int stop_address_pointer ;


int i;
int i_event_no ;

int return_code ;
int error_cnt ;
int loop_cnt ;
int max_no_events ;
int page_size     ;
int stop_delay ;
int trig_flag_clr_val ;

unsigned int wrap_start_addr ;
unsigned int page_lwords ;
unsigned int page_addr_mask ;
unsigned int  page_offset_addr ;
mod_base = vme_base_addr ;

/* page variables setup for test */
page_size          =  CONF_PAGE_SIZE_4K_WRAP  ;
page_lwords        =  PAGE_LWORDS_4K          ;
max_no_events      =  MAX_ADC_MEM_SIZE_LWORDS / PAGE_LWORDS_4K          ;
page_addr_mask     =  page_lwords - 1         ;
stop_delay         =  page_lwords >> 1        ; /* half size of pages */
trig_flag_clr_val  =  page_lwords + 0x100     ;

fprintf(stderr,"page_lwords       = 0x%08x \n",page_lwords);
fprintf(stderr,"max_no_events     = 0x%08x \n",max_no_events);
fprintf(stderr,"page_addr_mask    = 0x%08x \n",page_addr_mask);
fprintf(stderr,"stop_delay        = 0x%08x \n",stop_delay);
fprintf(stderr,"trig_flag_clr_val = 0x%08x \n",trig_flag_clr_val);
/* fprintf(stderr," = 0x%08x \n",); */





/* 1. Reset SIS330x  */
addr = mod_base + SIS3300_KEY_RESET ;                    /* reset */
return_code =  vme_A32D32_write(p, addr, 0x0) ;
if (return_code != 0) {fprintf(stderr,"vme_A32D32_write:return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}

/* 2a. write Configuration register */
/* 2b. write StopDelay */
/* 2c. write Trigger Setup register */
/* 2d. write Trigger Threshold register */
/* 2e. write Trigger Falg Clear Counter register */
/* 2f. write Configuration register */
/* 2g. write Acquisition register */

/* 2. Setup SIS330x                                                        */

/* 2a. write Configuration register */
data =    page_size   ;
addr = mod_base + SIS3300_EVENT_CONFIG_ALL_ADC ;    /* Event configuration register all ADCs */
return_code =  vme_A32D32_write(p, addr, data) ;
if (return_code != 0) {fprintf(stderr,"vme_A32D32_write:return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}


/* 2b. write StopDelay */
data = stop_delay ;
addr = mod_base + SIS3300_STOP_DELAY ;
return_code =  vme_A32D32_write(p, addr, data) ;
if (return_code != 0) {fprintf(stderr,"vme_A32D32_write: return_code = 0x%08x at address = 0x%08x\n",return_code,addr );return -1 ; }


/* 2c. write Trigger Setup register */
data =     TRIG_SETUP_ENABLE_PULS
        +  TRIG_SETUP_PULS_3_CLK
        +  TRIG_SETUP_ENABLE_NM_MODE
        +  TRIG_SETUP_N_OVER_3_CLK
        +  TRIG_SETUP_M_UNDER_3_CLK ;

addr = mod_base + SIS3300_TRIGGER_SETUP_ALL_ADC ;
return_code =  vme_A32D32_write(p, addr, data) ;
if (return_code != 0) {fprintf(stderr,"vme_A32D32_write: return_code = 0x%08x at address = 0x%08x\n",return_code,addr );return -1 ; }




/* 2d. write Trigger Threshold register */
data = 0x82008200 ;   /*  Trigger puls if value goes lower than 0x200 */
addr = mod_base + SIS3300_TRIGGER_THRESHOLD_ALL_ADC ;
return_code =  vme_A32D32_write(p, addr, data) ;
if (return_code != 0) {fprintf(stderr,"vme_A32D32_write: return_code = 0x%08x at address = 0x%08x\n",return_code,addr );return -1 ; }




/* 2e. write Trigger Falg Clear Counter register */
data = trig_flag_clr_val ;
addr = mod_base + SIS3300_TRIGGER_FLAG_CLR_CNT_ALL_ADC ;
return_code =  vme_A32D32_write(p, addr, data) ;
if (return_code != 0) {fprintf(stderr,"vme_A32D32_write: return_code = 0x%08x at address = 0x%08x\n",return_code,addr );return -1 ; }


/* 2f. write Configuration register */
data =    CTRL_ENABLE_INTERNAL_TRIGGER_STOP
       +  CTRL_ENABLE_TRIGGER_OUT_UPON_STARTED
       +  CTRL_USE_TRIGGER_OUTPUT_ON_OUTPUT1 ;
addr = mod_base + SIS3300_CONTROL_STATUS ;
return_code =  vme_A32D32_write(p, addr, data) ;
if (return_code != 0) {fprintf(stderr,"vme_A32D32_write: return_code = 0x%08x at address = 0x%08x\n",return_code,addr );return -1 ; }



/* 2g. write Acquisition register */
data =    ACQ_SET_CLOCK_TO_100MHZ
        + ACQ_ENABLE_STOP_DELAY
        + ACQ_ENABLE_MULTI_EVENT_MODE
        + ACQ_ENABLE_AUTOSTART
        + ACQ_ENABLE_BANK_SWITCH_MODE        ;
addr = mod_base + SIS3300_ACQUISTION_CONTROL ; 	/* Acq. register */
return_code =  vme_A32D32_write(p, addr, data) ;
if (return_code != 0) {fprintf(stderr,"vme_A32D32_write:return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}







/* 3. Start Sampling in AUTO_BANK_SWITCH Mode                              */
addr = mod_base + SIS3300_KEY_START_AUTO_BANK_SWITCH ;
return_code =  vme_A32D32_write(p, addr, 0x0) ;
if (return_code != 0) {fprintf(stderr,"vme_A32D32_write:return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}


   fprintf(stderr,"\n");
   fprintf(stderr,"\n");

   loop_cnt = 0;
   error_cnt = 0 ;
   return_code = 0 ;

/* 4. Readout Loop  */
do {
   fprintf(stderr,"\n");
   fprintf(stderr,"\n");



/* 4.1.1  wait for bank1 full; will happen after max_no_events or if end of memory of Bank1 has been reached */
   addr = mod_base + SIS3300_ACQUISTION_CONTROL ;
   do {
      return_code =  vme_A32D32_read(p, addr, &data) ;
    } while (((data & ACQ_STATUS_SWITCH_MODE_BANK1_FULL) != ACQ_STATUS_SWITCH_MODE_BANK1_FULL) && (return_code == 0x0)) ;
   if (return_code != 0) { fprintf(stderr,"vme_A32D32_read:return_code = 0x%08x  at addr = 0x%08x\n",return_code,addr );return -1;}


/* 4.1.2 Read data (Bank1 event counter,  address counter, event directory, ADC data)   */
      return_code =  vme_A32D32_read(p, mod_base + SIS3300_BANK1_EVENT_CNT_ADC12, &data) ;
      fprintf(stderr," SIS3300_BANK1_EVENT_CNT_ADC12:  0x%08x\n", data );
      return_code =  vme_A32D32_read(p, mod_base + SIS3300_BANK1_ADDR_CNT_ADC12, &data) ;
      fprintf(stderr," SIS3300_BANK1_ADDR_CNT_ADC12:   0x%08x\n", data );
      stop_address_pointer = data ;
      fprintf(stderr,"\n");
  /* read Event Directory Bank1 */
      addr = mod_base + SIS3300_EVENT_DIRECTORY_BANK1_ALL_ADC ;                    /*  Event Directory Bank1 */
      no_of_lwords = max_no_events ;
      return_code =   vme_A32BLT32_read(p, addr, gl_eventdir_data, no_of_lwords, &get_lwords) ;
      if (get_lwords != no_of_lwords)  {
          fprintf(stderr,"get_lwords = 0x%08x\n", get_lwords );
          error_cnt = error_cnt + 1;
        }

#ifdef printeventDir

   for (i=0;i<max_no_events;i++) {
        fprintf(stderr," SIS3300_EVENT_DIRECTORY_BANK1_ALL_ADC:  i = 0x%08x   blt_data[i] = 0x%08x    End Address = 0x%08x\n", i,
                                                                  gl_eventdir_data[i], (gl_eventdir_data[i] -1) );
   }
   fprintf(stderr,"\n");
#endif


/* this is not an optimized algo. to read and check !   it is only for testing */

/* read all ADC datas */
  /* read ADC1/ADC2 datas */
      addr = mod_base + SIS3300_MEMBASE_BANK1_ADC12 ;                    /*  Bank1 */
      no_of_lwords = MAX_ADC_MEM_SIZE_LWORDS ;
      return_code =   vme_A32MBLT64_read(p, addr, gl_blt1_data, no_of_lwords, &get_lwords) ;
      if (get_lwords != no_of_lwords) { fprintf(stderr,"get_lwords = 0x%08x\n", get_lwords );
          error_cnt = error_cnt + 1;
        }
  /* read ADC3/ADC4 datas */
      addr = mod_base + SIS3300_MEMBASE_BANK1_ADC34 ;                    /*  Bank1 */
      no_of_lwords = MAX_ADC_MEM_SIZE_LWORDS ;
      return_code =   vme_A32MBLT64_read(p, addr, gl_blt2_data, no_of_lwords, &get_lwords) ;
      if (get_lwords != no_of_lwords) { fprintf(stderr,"get_lwords = 0x%08x\n", get_lwords );
          error_cnt = error_cnt + 1;
        }
  /* read ADC5/ADC6 datas */
      addr = mod_base + SIS3300_MEMBASE_BANK1_ADC56 ;                    /*  Bank1 */
      no_of_lwords = MAX_ADC_MEM_SIZE_LWORDS ;
      return_code =   vme_A32MBLT64_read(p, addr, gl_blt3_data, no_of_lwords, &get_lwords) ;
      if (get_lwords != no_of_lwords) { fprintf(stderr,"get_lwords = 0x%08x\n", get_lwords );
          error_cnt = error_cnt + 1;
        }
  /* read ADC7/ADC8 datas */
      addr = mod_base + SIS3300_MEMBASE_BANK1_ADC78 ;                    /*  Bank1 */
      no_of_lwords = MAX_ADC_MEM_SIZE_LWORDS ;
      return_code =   vme_A32MBLT64_read(p, addr, gl_blt4_data, no_of_lwords, &get_lwords) ;
      if (get_lwords != no_of_lwords) { fprintf(stderr,"get_lwords = 0x%08x\n", get_lwords );
          error_cnt = error_cnt + 1;
        }

/* copy "only" gl_data to ADC buffer for each event  , here is no check of the Wrap bit and Triggerbit  */
   page_offset_addr = 0x0 ;
   for (i_event_no=0; i_event_no < max_no_events; i_event_no++) {
      wrap_start_addr = (gl_eventdir_data[i_event_no] & 0x1ffff) ;
      for (i=0; i < page_lwords; i++) {
        gl_ADC1_data[page_offset_addr+i] = (short)((gl_blt1_data[page_offset_addr + ((i+wrap_start_addr)& page_addr_mask )] >> 16) & 0x3fff);
        gl_ADC2_data[page_offset_addr+i] = (short)((gl_blt1_data[page_offset_addr + ((i+wrap_start_addr)& page_addr_mask )] ) & 0x3fff);
      }
      for (i=0; i < page_lwords; i++) {
        gl_ADC3_data[page_offset_addr+i] = (short)((gl_blt2_data[page_offset_addr + ((i+wrap_start_addr)& page_addr_mask )] >> 16) & 0x3fff);
        gl_ADC4_data[page_offset_addr+i] = (short)((gl_blt2_data[page_offset_addr + ((i+wrap_start_addr)& page_addr_mask )] ) & 0x3fff);
      }
      for (i=0; i < page_lwords; i++) {
        gl_ADC5_data[page_offset_addr+i] = (short)((gl_blt3_data[page_offset_addr + ((i+wrap_start_addr)& page_addr_mask )] >> 16) & 0x3fff);
        gl_ADC6_data[page_offset_addr+i] = (short)((gl_blt3_data[page_offset_addr + ((i+wrap_start_addr)& page_addr_mask )] ) & 0x3fff);
      }
      for (i=0; i < page_lwords; i++) {
        gl_ADC7_data[page_offset_addr+i] = (short)((gl_blt4_data[page_offset_addr + ((i+wrap_start_addr)& page_addr_mask )] >> 16) & 0x3fff);
        gl_ADC8_data[page_offset_addr+i] = (short)((gl_blt4_data[page_offset_addr + ((i+wrap_start_addr)& page_addr_mask )] ) & 0x3fff);
      }

      page_offset_addr =  page_offset_addr + page_lwords  ;    /* next page_offset_addr */
    }


#ifdef gnuplot
    printf("set yrange [0:4095]\n");

    printf("plot \"-\"  with line 1 \n");
    for (i=0;i<no_of_lwords;i++)  printf(" %8d %6d \n",i, gl_ADC1_data[i]) ;
    printf("e\n\n");

    printf("plot \"-\" with line 2 \n");
    for (i=0;i<no_of_lwords;i++)  printf(" %8d %6d \n",i, gl_ADC2_data[i]) ;
    printf("e\n\n");

#endif


#ifdef write_2_disk
/* write to disk */
    used_file = fopen("adc_bank1.txt","w");
    for (i=0;i<no_of_lwords;i++) {
/*    for (i=0;i<0x1000;i++) {   */
      fprintf(used_file," %8d %6d %6d %6d %6d %6d %6d %6d %6d  \n",i,
                              gl_ADC1_data[i],gl_ADC2_data[i],gl_ADC3_data[i],gl_ADC4_data[i],
                              gl_ADC5_data[i],gl_ADC6_data[i],gl_ADC7_data[i],gl_ADC8_data[i] ) ;
     }
    fclose(used_file) ;
#endif

/* check einbauen */
/* 4.1.3 Clear Bank1 Full Flag --> free for sampling on this bank again   */
   addr = mod_base + SIS3300_KEY_BANK1_FULL_FLAG ;
   return_code =  vme_A32D32_write(p, addr, 0x0) ;
   if (return_code != 0) {fprintf(stderr,"vme_A32D32_write: return_code = 0x%08x at address = 0x%08x\n",return_code,addr );return -1 ; }




     fprintf(stderr," \n");
     fprintf(stderr," \n");


/* 4.2.1  wait for bank2 full; will happen after max_no_events or if end of memory of Bank2 has been reached */
   addr = mod_base + SIS3300_ACQUISTION_CONTROL ;
   do {
      return_code =  vme_A32D32_read(p, addr, &data) ;
    } while (((data & ACQ_STATUS_SWITCH_MODE_BANK2_FULL) != ACQ_STATUS_SWITCH_MODE_BANK2_FULL) && (return_code == 0x0)) ;
   if (return_code != 0) { fprintf(stderr,"vme_A32D32_read:return_code = 0x%08x  at addr = 0x%08x\n",return_code,addr );return -1;}


/* 4.2.2 Read data (Bank2 event counter,  address counter, event directory, ADC data)   */
      return_code =  vme_A32D32_read(p, mod_base + SIS3300_BANK2_EVENT_CNT_ADC12, &data) ;
      fprintf(stderr," SIS3300_BANK2_EVENT_CNT_ADC12:  0x%08x\n", data );
      return_code =  vme_A32D32_read(p, mod_base + SIS3300_BANK2_ADDR_CNT_ADC12, &data) ;
      fprintf(stderr," SIS3300_BANK2_ADDR_CNT_ADC12:   0x%08x\n", data );
      stop_address_pointer = data ;
      fprintf(stderr,"\n");

  /* read Event Directory Bank2 */
      addr = mod_base + SIS3300_EVENT_DIRECTORY_BANK2_ALL_ADC ;                    /*  Event Directory Bank2 */
      no_of_lwords = max_no_events ;
      return_code =   vme_A32BLT32_read(p, addr, gl_eventdir_data, no_of_lwords, &get_lwords) ;
      if (get_lwords != no_of_lwords)  {
          fprintf(stderr,"get_lwords = 0x%08x\n", get_lwords );
          error_cnt = error_cnt + 1;
        }

#ifdef printeventDir
   for (i=0;i<max_no_events;i++) {
        fprintf(stderr," SIS3300_EVENT_DIRECTORY_BANK2_ALL_ADC:  i = 0x%08x   blt_data[i] = 0x%08x    End Address = 0x%08x\n", i,
                                                                  gl_eventdir_data[i], (gl_eventdir_data[i] -1) );
   }
   fprintf(stderr,"\n");
#endif

/* this is not an optimized algo. to read and check !   it is only for testing */

/* read all ADC datas */
  /* read ADC1/ADC2 datas */
      addr = mod_base + SIS3300_MEMBASE_BANK2_ADC12 ;                    /*  Bank2 */
      no_of_lwords = MAX_ADC_MEM_SIZE_LWORDS ;
      return_code =   vme_A32MBLT64_read(p, addr, gl_blt1_data, no_of_lwords, &get_lwords) ;
      if (get_lwords != no_of_lwords) { fprintf(stderr,"get_lwords = 0x%08x\n", get_lwords );
          error_cnt = error_cnt + 1;
        }
  /* read ADC3/ADC4 datas */
      addr = mod_base + SIS3300_MEMBASE_BANK2_ADC34 ;                    /*  Bank2 */
      no_of_lwords = MAX_ADC_MEM_SIZE_LWORDS ;
      return_code =   vme_A32MBLT64_read(p, addr, gl_blt2_data, no_of_lwords, &get_lwords) ;
      if (get_lwords != no_of_lwords) { fprintf(stderr,"get_lwords = 0x%08x\n", get_lwords );
          error_cnt = error_cnt + 1;
        }
  /* read ADC5/ADC6 datas */
      addr = mod_base + SIS3300_MEMBASE_BANK2_ADC56 ;                    /*  Bank2 */
      no_of_lwords = MAX_ADC_MEM_SIZE_LWORDS ;
      return_code =   vme_A32MBLT64_read(p, addr, gl_blt3_data, no_of_lwords, &get_lwords) ;
      if (get_lwords != no_of_lwords) { fprintf(stderr,"get_lwords = 0x%08x\n", get_lwords );
          error_cnt = error_cnt + 1;
        }
  /* read ADC7/ADC8 datas */
      addr = mod_base + SIS3300_MEMBASE_BANK2_ADC78 ;                    /*  Bank2 */
      no_of_lwords = MAX_ADC_MEM_SIZE_LWORDS ;
      return_code =   vme_A32MBLT64_read(p, addr, gl_blt4_data, no_of_lwords, &get_lwords) ;
      if (get_lwords != no_of_lwords) { fprintf(stderr,"get_lwords = 0x%08x\n", get_lwords );
          error_cnt = error_cnt + 1;
        }

/* copy "only" gl_data to ADC buffer for each event  , here is no check of the Wrap bit and Triggerbit  */
   page_offset_addr = 0x0 ;
   for (i_event_no=0; i_event_no < max_no_events; i_event_no++) {
      wrap_start_addr = (gl_eventdir_data[i_event_no] & 0x1ffff) ;
      for (i=0; i < page_lwords; i++) {
        gl_ADC1_data[page_offset_addr+i] = (short)((gl_blt1_data[page_offset_addr + ((i+wrap_start_addr)& page_addr_mask )] >> 16) & 0x3fff);
        gl_ADC2_data[page_offset_addr+i] = (short)((gl_blt1_data[page_offset_addr + ((i+wrap_start_addr)& page_addr_mask )] ) & 0x3fff);
      }
      for (i=0; i < page_lwords; i++) {
        gl_ADC3_data[page_offset_addr+i] = (short)((gl_blt2_data[page_offset_addr + ((i+wrap_start_addr)& page_addr_mask )] >> 16) & 0x3fff);
        gl_ADC4_data[page_offset_addr+i] = (short)((gl_blt2_data[page_offset_addr + ((i+wrap_start_addr)& page_addr_mask )] ) & 0x3fff);
      }
      for (i=0; i < page_lwords; i++) {
        gl_ADC5_data[page_offset_addr+i] = (short)((gl_blt3_data[page_offset_addr + ((i+wrap_start_addr)& page_addr_mask )] >> 16) & 0x3fff);
        gl_ADC6_data[page_offset_addr+i] = (short)((gl_blt3_data[page_offset_addr + ((i+wrap_start_addr)& page_addr_mask )] ) & 0x3fff);
      }
      for (i=0; i < page_lwords; i++) {
        gl_ADC7_data[page_offset_addr+i] = (short)((gl_blt4_data[page_offset_addr + ((i+wrap_start_addr)& page_addr_mask )] >> 16) & 0x3fff);
        gl_ADC8_data[page_offset_addr+i] = (short)((gl_blt4_data[page_offset_addr + ((i+wrap_start_addr)& page_addr_mask )] ) & 0x3fff);
      }

      page_offset_addr =  page_offset_addr + page_lwords  ;    /* next page_offset_addr */
    }

#ifdef gnuplot
    printf("set yrange [0:4095]\n");

    printf("plot \"-\"  with line 1 \n");
    for (i=0;i<no_of_lwords;i++)  printf(" %8d %6d \n",i, gl_ADC1_data[i]) ;
    printf("e\n\n");

    printf("plot \"-\" with line 2 \n");
    for (i=0;i<no_of_lwords;i++)  printf(" %8d %6d \n",i, gl_ADC2_data[i]) ;
    printf("e\n\n");

#endif

#ifdef write_2_disk
/* write to disk */
    used_file = fopen("adc_bank2.txt","w");
    for (i=0;i<no_of_lwords;i++) {
      fprintf(used_file," %8d %6d %6d %6d %6d %6d %6d %6d %6d \n",i,
                              gl_ADC1_data[i],gl_ADC2_data[i],gl_ADC3_data[i],gl_ADC4_data[i],
                              gl_ADC5_data[i],gl_ADC6_data[i],gl_ADC7_data[i],gl_ADC8_data[i] ) ;
     }
    fclose(used_file) ;

#endif
/* check einbauen */




/* 4.2.3 Clear Bank2 Full Flag --> free for sampling on this bank again   */
   addr = mod_base + SIS3300_KEY_BANK2_FULL_FLAG ;
   return_code =  vme_A32D32_write(p, addr, 0x0) ;
   if (return_code != 0) {fprintf(stderr,"vme_A32D32_write: return_code = 0x%08x at address = 0x%08x\n",return_code,addr );return -1 ; }


   fprintf(stderr,"\n");

   loop_cnt = loop_cnt + 1 ;
/*   if ((loop_cnt & 0xFF) == 0x0 ) */
   {
     fprintf(stderr," \n");
     fprintf(stderr," loop counter = 0x%08x \n", loop_cnt);
     fprintf(stderr," \n");
   }


 }while (return_code == 0);

  return -1 ;
}


