/* $ZEL: sis1100_block_read.c,v 1.1.2.2 2003/08/07 11:51:36 wuestner Exp $ */

/*
 * Copyright (c) 2001-2003
 * 	Matthias Drochner, Peter Wuestner.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <linux/config.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/types.h>
#include <linux/fs.h>
#include <linux/mm.h>
#include <linux/wrapper.h>
#include <linux/pci.h>
#include <asm/uaccess.h>

#include "sis1100_sc.h"
#undef ALLWAYS_DMA

int
sis1100_block_read (
    struct SIS1100_softc* sc,
    struct SIS1100_fdata* fd,
    struct sis1100_vme_block_req* req
    )
{
    size_t num=req->num;
    int res=0;

    if (!num) {req->error=0; return 0;}
    if (!sc->remote_ok) return -ENXIO;
    if (!access_ok(VERIFY_WRITE, req->data, num*req->size))
        return -EPERM;
#ifndef ALLWAYS_DMA
    if (num==1) {
        u_int32_t var;
        req->error=sis1100_tmp_read(sc, req->addr, req->am, req->size,
                1/*space*/, &var);
        switch (req->size) {
	case 4: __put_user(var, (u_int32_t*)req->data); break;
	case 2: __put_user(var, (u_int16_t*)req->data); break;
	case 1: __put_user(var, (u_int8_t*)req->data); break;
        }
    } else {
        if ((req->size==4)&&fd->mindmalen_r&&(num*req->size>=fd->mindmalen_r)) {
#endif
            res=sis1100_read_dma(fd, req->addr, req->am, req->size,
                    1/*space*/, req->fifo, num*req->size, (char*)req->data,
                    &req->error);
#ifndef ALLWAYS_DMA
        } else {
            res=sis1100_read_loop(fd, req->addr, req->am, req->size,
                    1/*space*/, req->fifo, num*req->size, (char*)req->data,
                    &req->error);
        }
    }
#endif
    /* read_dma and read_loop return number of addresses==bytes read... */
    switch(req->size){
            case 4: req->num  = res >> 2; break;
            case 2: req->num  = res >> 1; break;
            case 1: req->num  = res; break;
    }
    return res;
}

int
sis1100_block_write(
    struct SIS1100_softc* sc,
    struct SIS1100_fdata* fd,
    struct sis1100_vme_block_req* req
    )
{
    size_t num=req->num;
    int res=0;

    if (!num) {req->error=0; return 0;}
    if (!sc->remote_ok) return -ENXIO;
    if (!access_ok(VERIFY_READ, req->data, num*req->size))
        return -EPERM;
#ifndef ALLWAYS_DMA
    if (num==1) {
        u_int32_t data;
        switch (req->size) {
        case 1: __get_user(data, (u_int8_t*)req->data); break;
        case 2: __get_user(data, (u_int16_t*)req->data); break;
        case 4: __get_user(data, (u_int32_t*)req->data); break;
        default: data=0;
        }
        req->error=sis1100_tmp_write(sc, req->addr, req->am, req->size,
                1/*space*/, data);
    } else {
        if ((req->size==4)&&fd->mindmalen_w&&(num*req->size>=fd->mindmalen_w)) {
#endif
            res=sis1100_write_dma(fd, req->addr, req->am, req->size,
                    1/*space*/, req->fifo, num*req->size, (char*)req->data,
                    &req->error);
            req->num=res>>2; /* nonsense if res<0; but does not matter */
#ifndef ALLWAYS_DMA
        } else {
            res=sis1100_write_loop(fd, req->addr, req->am, req->size,
                    1/*space*/, req->fifo, num*req->size, (char*)req->data,
                    &req->error);
            req->num=res; /* nonsense if res<0; but does not matter */
        }
    }
#endif
    return res;
}
